<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method noticeCategoryListBySourceByParams(array $params)
 * @method noticeCategoryListByParams(array $params)
 * @method noticeListByParams(array $params)
 * @method noticeDetailByParams(array $params)
 * @method lastHonorNoticeDetailByParams(array $params)
 * @method noticeCategoryByNoticeCategoryIdByParams(array $params)
 * @method deleteNoticeByParams(array $params)
 * @method getAllNoticeReedsByParams(array $params)
 * @method getNoticeReedsListByParams(array $params)
 * @method getNoticesByNoticeIdsByParams(array $params)
 */
class Notice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建公告
     *
     * @support  int $noticeCategoryId 板块id [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 正文 [ require true ]
     * @support  array $noticeAnnex 附件信息 [ require false ]
     * @support  int $createBy 创建人 [ require false ]
     * @support  int $updateBy 修改人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑公告
     *
     * @support  int $id 公告id [ require true ]
     * @support  int $noticeCategoryId 板块id [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 正文 [ require true ]
     * @support  array $noticeAnnex 附件信息 [ require false ]
     * @support  int $createBy 创建人 [ require false ]
     * @support  int $updateBy 修改人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 获取公告板块列表名称
     *
     * @param  int $source 分类类型1普通公告，2荣耀榜单 [ require false ]
     * @param  string $scene 公告场景retail零售，operate运营 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function noticeCategoryListBySource (int $source = 1, string $scene = 'retail') {
        return self::getClass()->noticeCategoryListBySource([
            "source" => $source,
            "scene" => $scene,
        ]);
    }

    /**
     * 获取公告板块列表名称
     *
     * @support  string $scene 公告场景retail零售，operate运营 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function noticeCategoryList () {
        return self::getClass()->noticeCategoryList([
        ]);
    }

    /**
     * 公告列表查询
     *
     * @support  int $noticeCategoryId 公告板块类别 [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  string $publishAtBegin 发布时间开始 [ require false ]
     * @support  string $publishAtEnd 发布时间结束 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @support  int $userId 登录人userId [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function noticeList () {
        return self::getClass()->noticeList([
        ]);
    }

    /**
     * 公告详情
     *
     * @support  int $id 公告id [ require true ]
     * @support  int $userId 用户id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function noticeDetail () {
        return self::getClass()->noticeDetail([
        ]);
    }

    /**
     * 获取最新的一篇荣耀榜公告
     *
     * @support  int $userId 用户id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function lastHonorNoticeDetail () {
        return self::getClass()->lastHonorNoticeDetail([
        ]);
    }

    /**
     * 根据公告板块id，查询板块信息
     *
     * @param  int $noticeCategoryId 公告分类板块id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function noticeCategoryByNoticeCategoryId (int $noticeCategoryId) {
        return self::getClass()->noticeCategoryByNoticeCategoryId([
            "noticeCategoryId" => $noticeCategoryId,
        ]);
    }

    /**
     * 删除公告
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteNotice (int $id) {
        return self::getClass()->deleteNotice([
            "id" => $id,
        ]);
    }

    /**
     * 根据公告id和员工id获取阅读情况
     *
     * @support  int $noticeId 公告id [ require false ]
     * @support  array $noticeIds 公告ids [ require false ]
     * @support  int $userId 用户id [ require false ]
     * @support  array $userIds 用户ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllNoticeReeds () {
        return self::getClass()->getAllNoticeReeds([
        ]);
    }

    /**
     * 根据公告id和员工id获取阅读情况
     *
     * @support  int $noticeId 公告id [ require false ]
     * @support  array $noticeIds 公告ids [ require false ]
     * @support  int $userId 用户id [ require false ]
     * @support  array $userIds 用户ids [ require false ]
     * @param  int $page 第几页数 [ require true ]
     * @param  int $pageSize 数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoticeReedsList (int $page, int $pageSize) {
        return self::getClass()->getNoticeReedsList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据公告ids获取公告
     *
     * @param  array $noticeIds 公告ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoticesByNoticeIds (array $noticeIds) {
        return self::getClass()->getNoticesByNoticeIds([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Notice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Notice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}