<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method repealReceiptProductByParams(array $params)
 * @method listByParams(array $params)
 * @method receiptInfoByParams(array $params)
 * @method receiptProductListByParams(array $params)
 */
class StoreReceipt {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加收货信息
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $staffId 收货人id [ require true ]
     * @param  string $note 备注 [ require true ]
     * @param  array $receiptProducts 发货的产品明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $storeId, int $staffId, string $note = '', array $receiptProducts = []) {
        return self::getClass()->create([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "note" => $note,
            "receiptProducts" => $receiptProducts,
        ]);
    }

    /**
     * 撤销收货信息
     *
     * @param  int $id 发货商品id [ require true ]
     * @param  int $storeReceiptId 收货单id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function repealReceiptProduct (int $id, int $storeReceiptId, int $operateId) {
        return self::getClass()->repealReceiptProduct([
            "id" => $id,
            "storeReceiptId" => $storeReceiptId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取发货单列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $staffId 录入伙伴id require false
     * @support  string $createTimeStart 创建开始时间 require false
     * @support  string $createTimeEnd 创建结束时间 require false
     * @support  int $page 当前页 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取收货单基本信息
     *
     * @param  int $id 收货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiptInfo (int $id) {
        return self::getClass()->receiptInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取收货单商品列表
     *
     * @param  int $id 收货单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $productName 商品名称 [ require true ]
     * @param  string $skuCode sku编码 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiptProductList (int $id, int $storeId, string $productName = '', string $skuCode = '', string $status = '', int $page = 0, int $pageSize = 20) {
        return self::getClass()->receiptProductList([
            "id" => $id,
            "storeId" => $storeId,
            "productName" => $productName,
            "skuCode" => $skuCode,
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'StoreReceipt');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'StoreReceipt');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}