<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method getProductListWithSkusByParams(array $params)
 * @method getProductListWithSkuAndStockByParams(array $params)
 * @method getProductListByIdsByParams(array $params)
 * @method getProductListBySkuIdsByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method getSkuInfoByParams(array $params)
 * @method setSellPriceByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method batchSetTagsByParams(array $params)
 * @method getTagStatusByParams(array $params)
 * @method getTagProductListByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 * @method getSkuBySkuCodeByParams(array $params)
 * @method getProductIdsBySkuIdsByParams(array $params)
 * @method setProductStoreGroupByParams(array $params)
 * @method addProductStoreGroupByParams(array $params)
 * @method getProductStoreGroupByParams(array $params)
 * @method clearStoreGroupByProductIdByParams(array $params)
 * @method deleteStoreGroupByProductIdByParams(array $params)
 * @method deleteProductStoreGroupByParams(array $params)
 * @method updateSkuByParams(array $params)
 * @method getSkuGroupByParams(array $params)
 * @method getSkuGroupByRelationIdsByParams(array $params)
 * @method batchUpdateSkuImageByParams(array $params)
 * @method batchCreateProductByParams(array $params)
 * @method getMessageLogByParams(array $params)
 * @method getSkuBySkuIdsByParams(array $params)
 * @method getSkuBySkuIdByParams(array $params)
 * @method getNeedInventoryCheckSkuByParams(array $params)
 * @method getInventoryCheckSkuListByParams(array $params)
 * @method getAllSkuByParams(array $params)
 * @method allByParams(array $params)
 * @method getStoreIdsByProductIdByParams(array $params)
 * @method getProductSkusAndSpecificationsByIdByParams(array $params)
 * @method getProductSkusWithCategoryByParams(array $params)
 * @method getStockByStoreIdAndSkuIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  int $isCombine 是否是组合商品 [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3定制商品 require false
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [ require true ]
     * @support  int $brandId 分类ID [ require true ]
     * @support  array $categoryAttrs 商品分类属性 require false
     * @support  array $skus 商品skus [ require true ]
     * @support  int $supplierId 供应商id require false
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @support  int $type 产品类型 1零售商品，2陈列商品，3定制商品 require false
     * @support  int $offlineSales 门店端销售商品 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 编辑产品基本信息
     *
     * @param  int $id 产品id [ require true ]
     * @support  string $name 产品名称 require false
     * @support  int $categoryId 分类ID require false
     * @support  int $brandId 分类ID require false
     * @support  array $categoryAttrs 产品主图 require false
     * @support  int $supplierId 供应商id require false
     * @support  bool $needCheckStock 是否需要盘点 require false
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 require false
     * @support  int $offlineSales 门店端销售商品 require false
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $operateId = 0) {
        return self::getClass()->update([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [ require true ]
     * @param  string $status 产品状态 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $from 来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $from = 'mobile', int $storeId = 0, string $status = '') {
        return self::getClass()->detail([
            "id" => $id,
            "from" => $from,
            "storeId" => $storeId,
            "status" => $status,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  array $types 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  string $name 名称(模糊查询) require false
     * @support  int $categoryId 分类ID require false
     * @support  array $categoryIds 分类ID列表 require false
     * @support  int $brandId 品牌ID require false
     * @support  array $status 状态 require false
     * @support  int $onlineSales 预约端1/0 require false
     * @support  int $offlineSales 门店端1/0 require false
     * @support  string $startAt 创建时间 require false
     * @support  string $endAt 更新时间 require false
     * @support  int $needLabel 是否需要展示标签1/0 require false
     * @support  int $isCombine 组合商品 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取商品(门店端)
     * @deprecated
     *
     * @support  array $storeIds 门店ids require false
     * @support  string $name 名称 require false
     * @support  array $categoryIds 品类ids require false
     * @support  array $status 状态 require false
     * @support  string $skuCode sku编码 require false
     * @support  array $needExtend 需要扩展的属性值 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListWithSkus (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductListWithSkus([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据条件获取门店的商品信息
     *
     * @support  array $storeIds 门店ids [ require true ]
     * @support  string $name 名称 require false
     * @support  array $categoryIds 品类ids require false
     * @support  array $status 状态 require false
     * @support  string $skuCode sku编码 require false
     * @support  array $needExtend 需要扩展的属性值 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListWithSkuAndStock (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductListWithSkuAndStock([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 预约端根据门店id和产品ids获取对应产品的详细信息
     *
     * @support  array $ids 产品ids [ require true ]
     * @support  int $storeId 店铺id require false
     * @support  int $onlineSale 是否线上销售:1 是 0 否 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListByIds () {
        return self::getClass()->getProductListByIds();
    }

    /**
     * 根据SKU获取门店对应产品信息
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  array $skuIds SKUids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListBySkuIds () {
        return self::getClass()->getProductListBySkuIds();
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function up (int $id, int $operateId) {
        return self::getClass()->up([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function off (int $id, int $operateId) {
        return self::getClass()->off([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取sku详情
     *
     * @param  int $skuId skuId [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuInfo (int $skuId, string $from = 'mobile', bool $withOffSku = false) {
        return self::getClass()->getSkuInfo([
            "skuId" => $skuId,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 配置sku的现价/售价
     *
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSellPrice (array $data) {
        return self::getClass()->setSellPrice([
            "data" => $data,
        ]);
    }

    /**
     * 设置产品标签
     *
     * @param  int $id 产品id [ require true ]
     * @param  array $tags 标签:new新品,major重点,main主推,清货clear [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function setTags (int $id, array $tags = []) {
        return self::getClass()->setTags([
            "id" => $id,
            "tags" => $tags,
        ]);
    }

    /**
     * 批量设置产品标签
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @param  array $updateTags 二维数组[标签id,开始时间startAt,结束时间endAt] [ require true ]
     * @param  array $delTags [标签id,标签id] [ require true ]
     * @param  int $operateId 操作人工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSetTags (array $ids, array $updateTags = [], array $delTags = [], int $operateId) {
        return self::getClass()->batchSetTags([
            "ids" => $ids,
            "updateTags" => $updateTags,
            "delTags" => $delTags,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据产品id获取标签状态
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTagStatus (array $ids) {
        return self::getClass()->getTagStatus([
            "ids" => $ids,
        ]);
    }

    /**
     * 标签产品列表
     *
     * @support  int $tagId 标签id [ require true ]
     * @support  string $productName 产品名称 require false
     * @support  string $startAtBegin 生效时间开始 require false
     * @support  string $startAtEnd 生效时间结束 require false
     * @support  string $endAtBegin 失效时间开始 require false
     * @support  string $endAtEnd 失效时间结束 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTagProductList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTagProductList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * 根据编码获取sku信息
     *
     * @param  string $skuCode 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuCode (string $skuCode) {
        return self::getClass()->getSkuBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * 根据skuIds获取sku对应的产品id
     *
     * @param  array $skuIds skuId列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductIdsBySkuIds (array $skuIds) {
        return self::getClass()->getProductIdsBySkuIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 配置门店组
     *
     * @param  array $ids 商品ids [ require true ]
     * @param  array $storeGroupIds 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 新增零售商品关联门店组/门店
     *
     * @param  int $id 商品id [ require true ]
     * @param  array $storeGroupIds 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductStoreGroup (int $id, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->addProductStoreGroup([
            "id" => $id,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取产品对应门店组
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductStoreGroup (int $id) {
        return self::getClass()->getProductStoreGroup([
            "id" => $id,
        ]);
    }

    /**
     * 清空商品与门店、门店组关系
     *
     * @param  int $id 商品id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearStoreGroupByProductId (int $id, int $operateId) {
        return self::getClass()->clearStoreGroupByProductId([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 清空商品与门店关系
     *
     * @param  int $id 商品id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStoreGroupByProductId (int $id, array $storeIds, int $operateId) {
        return self::getClass()->deleteStoreGroupByProductId([
            "id" => $id,
            "storeIds" => $storeIds,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除产品对应门店组
     *
     * @param  int $id 商品id [ require true ]
     * @param  int $groupId 分组id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductStoreGroup (int $id, int $groupId = 0, int $storeId = 0) {
        return self::getClass()->deleteProductStoreGroup([
            "id" => $id,
            "groupId" => $groupId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 修改sku信息
     *
     * @param  int $productId 商品id [ require true ]
     * @param  array $skus sku信息 [ require true ]
     * @param  array $groups 组合sku信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSku (int $productId, array $skus, array $groups, int $operateId) {
        return self::getClass()->updateSku([
            "productId" => $productId,
            "skus" => $skus,
            "groups" => $groups,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取组合的sku信息
     *
     * @param  int $relationId sku的关联id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuGroup (int $relationId) {
        return self::getClass()->getSkuGroup([
            "relationId" => $relationId,
        ]);
    }

    /**
     * 获取组合的sku信息
     *
     * @param  array $relationIds 组合商品的skuId列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuGroupByRelationIds (array $relationIds) {
        return self::getClass()->getSkuGroupByRelationIds([
            "relationIds" => $relationIds,
        ]);
    }

    /**
     * 批量修改sku图片
     *
     * @param  string $type name,code根据名称,编码匹配 [ require true ]
     * @param  array $info 待匹配的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdateSkuImage (string $type, array $info) {
        return self::getClass()->batchUpdateSkuImage([
            "type" => $type,
            "info" => $info,
        ]);
    }

    /**
     * 批量上传商品
     *
     * @param  int $operateId 操作人工号 [ require true ]
     * @param  array $info 待匹配的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreateProduct (int $operateId, array $info) {
        return self::getClass()->batchCreateProduct([
            "operateId" => $operateId,
            "info" => $info,
        ]);
    }

    /**
     * 获取商品操作记录
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageLog (int $id) {
        return self::getClass()->getMessageLog([
            "id" => $id,
        ]);
    }

    /**
     * 根据skuIds获取详情
     *
     * @param  array $skuIds skuIds [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuIds (array $skuIds, string $from = 'mobile', bool $withOffSku = false) {
        return self::getClass()->getSkuBySkuIds([
            "skuIds" => $skuIds,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 根据skuId获取详情
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuId (int $skuId) {
        return self::getClass()->getSkuBySkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNeedInventoryCheckSku (bool $withOffSku = false) {
        return self::getClass()->getNeedInventoryCheckSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku列表
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  int $categoryId 分类id [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInventoryCheckSkuList (int $storeId, int $categoryId = 0, int $page = 1, int $pageSize = 20, bool $withOffSku = false) {
        return self::getClass()->getInventoryCheckSkuList([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
            "page" => $page,
            "pageSize" => $pageSize,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取所有的sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllSku (bool $withOffSku = false) {
        return self::getClass()->getAllSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取全部产品列表(门店端在使用)
     *
     * @support  string $name 名称(模糊查询) require false
     * @support  int $categoryId 分类ID require false
     * @support  bool $showDeleted 是否显示已删除信息 require false
     * @support  string $status 状态 require false
     * @support  array $storeIds 店铺ids require false
     * @support  string $from 查询来源 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 根据商品id获取在售卖的门店ids
     *
     * @param  int $productId 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreIdsByProductId (int $productId) {
        return self::getClass()->getStoreIdsByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * 根据商品id获取对应的skus信息和specifications信息
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductSkusAndSpecificationsById (int $id) {
        return self::getClass()->getProductSkusAndSpecificationsById([
            "id" => $id,
        ]);
    }

    /**
     * 分页获取productSku表中商品信息，附带3级分类信息
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductSkusWithCategory (int $page, int $pageSize) {
        return self::getClass()->getProductSkusWithCategory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据门店id和skuIds获取对应的库存
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  array $skuIds skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockByStoreIdAndSkuIds (int $storeId, array $skuIds) {
        return self::getClass()->getStockByStoreIdAndSkuIds([
            "storeId" => $storeId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}