<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method createProductAndProductSkuByParams(array $params)
 * @method updateProductSkuByParams(array $params)
 * @method productListByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method productSkuListWithPaginateByParams(array $params)
 * @method shelveProductSkuByParams(array $params)
 * @method unshelveProductSkuByParams(array $params)
 */
class SellChannel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建销售渠道
     *
     * @support  string $name 渠道名称 [ require true ]
     * @support  int $isStoreSell 是否门店售卖 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 销售渠道列表
     *
     * @support  int $id 渠道id require false
     * @support  array $ids 渠道id数组 require false
     * @support  string $code 渠道code require false
     * @support  array $codes 渠道code数组 require false
     * @support  string $name 渠道名称 require false
     * @support  int $isStoreSell 是否门店售卖 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 销售渠道创建productSku
     *
     * @support  mixed $content  require false
     * @throws  \Exception
     * @return  bool
     */
    public static function createProductAndProductSku () {
        return self::getClass()->createProductAndProductSku();
    }

    /**
     * 销售渠道更新productSku
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateProductSku () {
        return self::getClass()->updateProductSku();
    }

    /**
     * 销售渠道product列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function productList () {
        return self::getClass()->productList();
    }

    /**
     * 销售渠道productSku列表
     *
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  array $categoryIds 销售渠道productSkuId数组 require false
     * @support  string $skuName 销售渠道skuName require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList();
    }

    /**
     * 销售渠道productSku列表 - 分页
     *
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  int $categoryIds 销售渠道productSkuId数组 require false
     * @support  string $skuName 销售渠道skuName require false
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuListWithPaginate () {
        return self::getClass()->productSkuListWithPaginate();
    }

    /**
     * 批量销售渠道上架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->shelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 批量销售渠道下架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->unshelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'SellChannel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'SellChannel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}