<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method productSkuBatchCreateByParams(array $params)
 * @method productSkuBatchUpdateByParams(array $params)
 * @method productDisableByParams(array $params)
 * @method productEnableByParams(array $params)
 * @method productSkuDisableByParams(array $params)
 * @method productSkuEnableByParams(array $params)
 * @method productListByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method getProductListWithSkusByParams(array $params)
 * @method getProductListWithSkuAndStockByParams(array $params)
 * @method getProductListByIdsByParams(array $params)
 * @method getProductListBySkuIdsByParams(array $params)
 * @method getSkuInfoByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method batchSetTagsByParams(array $params)
 * @method getTagStatusByParams(array $params)
 * @method getTagProductListByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 * @method getSkuBySkuCodeByParams(array $params)
 * @method getProductIdsBySkuIdsByParams(array $params)
 * @method setProductStoreGroupByParams(array $params)
 * @method addProductSkuStoreGroupByParams(array $params)
 * @method getProductSkuStoreGroupByParams(array $params)
 * @method clearStoreGroupBySkuIdByParams(array $params)
 * @method deleteStoreGroupBySkuIdByParams(array $params)
 * @method deleteProductSkuStoreGroupByParams(array $params)
 * @method getSkuGroupByParams(array $params)
 * @method getSkuGroupByRelationIdsByParams(array $params)
 * @method getMessageLogByParams(array $params)
 * @method getSkuBySkuIdsByParams(array $params)
 * @method getSkuBySkuIdByParams(array $params)
 * @method getNeedInventoryCheckSkuByParams(array $params)
 * @method getAllSkuByParams(array $params)
 * @method allByParams(array $params)
 * @method getProductSkusAndSpecificationsByIdByParams(array $params)
 * @method getProductSkusWithCategoryByParams(array $params)
 * @method getInventoryCheckSkuListByParams(array $params)
 * @method getStockByStoreIdAndSkuIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  int $type 1零售商品，2易耗品，3门店定制商品，4商城定制产品 require false
     * @support  int $categoryId 分类ID [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  array $newMainImage 商品主图 require false
     * @support  array $bannerUrl banner图 require false
     * @support  array $descriptionUrl 商品详情图 require false
     * @support  int $needCheckStock 是否需要盘点,0不需要要，1需要 require false
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新产品
     *
     * @support  int $id 产品id [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3定制商品, 4定制商城 require false
     * @support  int $categoryId 分类ID [ require true ]
     * @support  int $groupId 分组ID require false
     * @support  string $name 产品名称 [ require true ]
     * @support  array $newMainImage 商品主图 require false
     * @support  array $bannerUrl banner图 require false
     * @support  array $descriptionUrl 商品详情图 require false
     * @support  bool $needCheckStock 是否需要盘点 require false
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 创建productSku
     *
     * @support  int $productId 商品productId [ require true ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  array $productExtendMetric 商品productSku信息 [ require true ]
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuBatchCreate () {
        return self::getClass()->productSkuBatchCreate();
    }

    /**
     * 更新productSku
     *
     * @support  int $productId 商品productId [ require true ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  array $productExtendMetric 商品productSku信息 [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuBatchUpdate () {
        return self::getClass()->productSkuBatchUpdate();
    }

    /**
     * product停用
     *
     * @param  int $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productDisable (int $productId) {
        return self::getClass()->productDisable([
            "productId" => $productId,
        ]);
    }

    /**
     * product启用
     *
     * @param  int $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productEnable (int $productId) {
        return self::getClass()->productEnable([
            "productId" => $productId,
        ]);
    }

    /**
     * productSku停用
     *
     * @param  int $productSkuId 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuDisable (int $productSkuId) {
        return self::getClass()->productSkuDisable([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * productSku启用
     *
     * @param  int $productSkuId 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuEnable (int $productSkuId) {
        return self::getClass()->productSkuEnable([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * product列表 - 分页
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function productList () {
        return self::getClass()->productList();
    }

    /**
     * productSku列表 - 不分页
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList();
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [ require true ]
     * @param  string $status 产品状态 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $from 来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $from = 'mobile', int $storeId = 0, string $status = '') {
        return self::getClass()->detail([
            "id" => $id,
            "from" => $from,
            "storeId" => $storeId,
            "status" => $status,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  array $types 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  string $name 名称(模糊查询) require false
     * @support  int $categoryId 分类ID require false
     * @support  array $categoryIds 分类ID列表 require false
     * @support  int $brandId 品牌ID require false
     * @support  array $status 状态 require false
     * @support  int $onlineSales 预约端1/0 require false
     * @support  int $offlineSales 门店端1/0 require false
     * @support  string $startAt 创建时间 require false
     * @support  string $endAt 更新时间 require false
     * @support  int $needLabel 是否需要展示标签1/0 require false
     * @support  int $isCombine 组合商品 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取商品(门店端)
     * @deprecated
     *
     * @support  array $storeIds 门店ids require false
     * @support  string $name 名称 require false
     * @support  array $categoryIds 品类ids require false
     * @support  array $status 状态 require false
     * @support  string $skuCode sku编码 require false
     * @support  array $needExtend 需要扩展的属性值 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListWithSkus (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductListWithSkus([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据条件获取门店的商品信息
     *
     * @support  array $storeIds 门店ids [ require true ]
     * @support  string $name 名称 require false
     * @support  array $categoryIds 品类ids require false
     * @support  array $status 状态 require false
     * @support  string $skuCode sku编码 require false
     * @support  array $needExtend 需要扩展的属性值 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListWithSkuAndStock (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductListWithSkuAndStock([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 预约端根据门店id和产品ids获取对应产品的详细信息
     * @deprecated
     *
     * @support  array $ids 产品ids [ require true ]
     * @support  int $storeId 店铺id require false
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListByIds () {
        return self::getClass()->getProductListByIds();
    }

    /**
     * 根据SKU获取门店对应产品信息
     * @deprecated
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  array $skuIds SKUids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListBySkuIds () {
        return self::getClass()->getProductListBySkuIds();
    }

    /**
     * 获取sku详情
     *
     * @param  int $skuId skuId [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfo (int $skuId, string $from = 'mobile', bool $withOffSku = false) {
        return self::getClass()->getSkuInfo([
            "skuId" => $skuId,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 设置产品标签
     *
     * @param  int $id 产品id [ require true ]
     * @param  array $tags 标签:new新品,major重点,main主推,清货clear [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function setTags (int $id, array $tags = []) {
        return self::getClass()->setTags([
            "id" => $id,
            "tags" => $tags,
        ]);
    }

    /**
     * 批量设置产品标签
     * @deprecated
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @param  array $updateTags 二维数组[标签id,开始时间startAt,结束时间endAt] [ require true ]
     * @param  array $delTags [标签id,标签id] [ require true ]
     * @param  int $operateId 操作人工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSetTags (array $ids, array $updateTags = [], array $delTags = [], int $operateId) {
        return self::getClass()->batchSetTags([
            "ids" => $ids,
            "updateTags" => $updateTags,
            "delTags" => $delTags,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据产品id获取标签状态
     * @deprecated
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTagStatus (array $ids) {
        return self::getClass()->getTagStatus([
            "ids" => $ids,
        ]);
    }

    /**
     * 标签产品列表
     * @deprecated
     *
     * @support  int $tagId 标签id [ require true ]
     * @support  string $productName 产品名称 require false
     * @support  string $startAtBegin 生效时间开始 require false
     * @support  string $startAtEnd 生效时间结束 require false
     * @support  string $endAtBegin 失效时间开始 require false
     * @support  string $endAtEnd 失效时间结束 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTagProductList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTagProductList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * 根据编码获取sku信息
     *
     * @param  string $skuCode 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuCode (string $skuCode) {
        return self::getClass()->getSkuBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * 根据skuIds获取sku对应的产品id
     * @deprecated
     *
     * @param  array $skuIds skuId列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductIdsBySkuIds (array $skuIds) {
        return self::getClass()->getProductIdsBySkuIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 批量对商品配置门店组
     *
     * @param  array $ids 商品ids [ require true ]
     * @param  array $storeGroupIds 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 新增零售商品sku关联门店组/门店
     *
     * @param  int $skuId 商品skuId [ require true ]
     * @param  array $storeGroupIds 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductSkuStoreGroup (int $skuId, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->addProductSkuStoreGroup([
            "skuId" => $skuId,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取商品skuId对应门店组
     *
     * @param  int $skuId 商品skuId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductSkuStoreGroup (int $skuId) {
        return self::getClass()->getProductSkuStoreGroup([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 清空商品Sku与门店、门店组关系
     *
     * @param  int $skuId 商品skuid [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearStoreGroupBySkuId (int $skuId, int $operateId) {
        return self::getClass()->clearStoreGroupBySkuId([
            "skuId" => $skuId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除商品与门店关系
     *
     * @param  int $skuId 商品id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteStoreGroupBySkuId (int $skuId, array $storeIds, int $operateId) {
        return self::getClass()->deleteStoreGroupBySkuId([
            "skuId" => $skuId,
            "storeIds" => $storeIds,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除产品对应门店组
     *
     * @param  int $skuId 商品skuId [ require true ]
     * @param  int $groupId 分组id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductSkuStoreGroup (int $skuId, int $groupId = 0, int $storeId = 0) {
        return self::getClass()->deleteProductSkuStoreGroup([
            "skuId" => $skuId,
            "groupId" => $groupId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取组合的sku信息
     *
     * @param  int $relationId sku的关联id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuGroup (int $relationId) {
        return self::getClass()->getSkuGroup([
            "relationId" => $relationId,
        ]);
    }

    /**
     * 获取组合的sku信息
     * @deprecated
     *
     * @param  array $relationIds 组合商品的skuId列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuGroupByRelationIds (array $relationIds) {
        return self::getClass()->getSkuGroupByRelationIds([
            "relationIds" => $relationIds,
        ]);
    }

    /**
     * 获取商品操作记录
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageLog (int $id) {
        return self::getClass()->getMessageLog([
            "id" => $id,
        ]);
    }

    /**
     * 根据skuIds获取详情
     * @deprecated
     *
     * @param  array $skuIds skuIds [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuBySkuIds (array $skuIds, string $from = 'mobile', bool $withOffSku = false) {
        return self::getClass()->getSkuBySkuIds([
            "skuIds" => $skuIds,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 根据skuId获取详情
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuBySkuId (int $skuId) {
        return self::getClass()->getSkuBySkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNeedInventoryCheckSku (bool $withOffSku = false) {
        return self::getClass()->getNeedInventoryCheckSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取所有的sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSku (bool $withOffSku = false) {
        return self::getClass()->getAllSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取全部产品列表(门店端在使用)
     * @deprecated
     *
     * @support  string $name 名称(模糊查询) require false
     * @support  int $categoryId 分类ID require false
     * @support  bool $showDeleted 是否显示已删除信息 require false
     * @support  string $status 状态 require false
     * @support  array $storeIds 店铺ids require false
     * @support  string $from 查询来源 require false
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 根据商品id获取对应的skus信息和specifications信息
     * @deprecated
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkusAndSpecificationsById (int $id) {
        return self::getClass()->getProductSkusAndSpecificationsById([
            "id" => $id,
        ]);
    }

    /**
     * 分页获取productSku表中商品信息，附带3级分类信息
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductSkusWithCategory (int $page, int $pageSize) {
        return self::getClass()->getProductSkusWithCategory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku列表
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventoryCheckSkuList (int $storeId, int $page = 1, int $pageSize = 20, bool $withOffSku = false) {
        return self::getClass()->getInventoryCheckSkuList([
            "storeId" => $storeId,
            "page" => $page,
            "pageSize" => $pageSize,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 根据门店id和skuIds获取对应的库存
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  array $skuIds skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockByStoreIdAndSkuIds (int $storeId, array $skuIds) {
        return self::getClass()->getStockByStoreIdAndSkuIds([
            "storeId" => $storeId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}