<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|SellChannel\Create\SellChannelCmd $params)
 * @method listByParams(array|SellChannel\ListSafeNamespace\SellChannelListCmd $params)
 */
class SellChannel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  SellChannel\Create\SellChannelCmd $sellChannelCmd $sellChannelCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (SellChannel\Create\SellChannelCmd $sellChannelCmd) {
        return self::getClass()->create($sellChannelCmd);
    }


    /**
     * list
     *
     * @var  SellChannel\ListSafeNamespace\SellChannelListCmd $sellChannelListCmd $sellChannelListCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (SellChannel\ListSafeNamespace\SellChannelListCmd $sellChannelListCmd) {
        return self::getClass()->list($sellChannelListCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Rpc\SellChannel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Rpc\SellChannel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}