<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getByIdsByParams(array $params)
 * @method allByParams(array $params)
 */
class Brand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建品牌
     *
     * @param  uint $createBy 创建人工号 [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $introduction 介绍 [ require true ]
     * @param  string $imageUrl 图片 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (int $createBy, string $name, string $introduction = '', string $imageUrl = '') {
        return self::getClass()->create([
            "createBy" => $createBy,
            "name" => $name,
            "introduction" => $introduction,
            "imageUrl" => $imageUrl,
        ]);
    }

    /**
     * 修改品牌
     *
     * @param  uint $id id [ require true ]
     * @param  uint $updateBy 创建人工号 [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $introduction 介绍 [ require true ]
     * @param  string $imageUrl 图片 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, int $updateBy, string $name, string $introduction = '', string $imageUrl = '') {
        return self::getClass()->update([
            "id" => $id,
            "updateBy" => $updateBy,
            "name" => $name,
            "introduction" => $introduction,
            "imageUrl" => $imageUrl,
        ]);
    }

    /**
     * 品牌列表
     *
     * @param  string $name 名称 [ require true ]
     * @param  uint $page 页码 [ require true ]
     * @param  uint $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除品牌
     *
     * @param  uint $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取品牌
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIds (array $ids) {
        return self::getClass()->getByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 所有品牌
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $name = '') {
        return self::getClass()->all([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Brand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Brand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}