<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method productSkuBatchCreateByParams(array $params)
 * @method productSkuBatchUpdateByParams(array $params)
 * @method productSkuDeleteByParams(array $params)
 * @method productSkuUpByParams(array $params)
 * @method productSkuOffByParams(array $params)
 * @method productUpByParams(array $params)
 * @method productOffByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailWithSkuByParams(array $params)
 * @method getProductByIdByParams(array $params)
 * @method getProductSkuByProductIdByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method productSkuAllListByParams(array $params)
 * @method listByParams(array $params)
 * @method allListByParams(array $params)
 * @method getSkuByProductIdsOrderBySellPriceByParams(array $params)
 * @method getAllSkuByTypeByParams(array $params)
 * @method getProductSkuCunXinByProductSkuOutSkuIdByParams(array $params)
 * @method getProductSkuByProductSkuIdByParams(array $params)
 * @method getSkuMetricItemsBySkuIdsByParams(array $params)
 */
class ProductV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  uint $isCombine 是否是组合商品 [ require true ]
     * @support  uint $type 1零售商品，2陈列商品，3门店定制商品，4商城定制产品 require false
     * @support  uint $categoryId 分类ID [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  uint $brandId 品牌id [ require true ]
     * @support  array $newMainImage 商品主图 require false
     * @support  array $bannerUrl banner图 require false
     * @support  array $descriptionUrl 商品详情图 require false
     * @support  uint $needCheckStock 是否需要盘点,0不需要要，1需要 require false
     * @support  array $categoryAttrs 商品分类属性 require false
     * @support  uint $outProductId 外部产品id require false
     * @support  string $source 外部产品的业务方, 存心：cunxin require false
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新产品
     *
     * @support  uint $id 产品id [ require true ]
     * @support  uint $isCombine 是否是组合商品 [ require true ]
     * @support  uint $type 1零售商品，2陈列商品，3定制商品 require false
     * @support  uint $categoryId 分类ID [ require true ]
     * @support  uint $groupId 分组ID require false
     * @support  string $name 产品名称 [ require true ]
     * @support  uint $brandId 品牌id [ require true ]
     * @support  array $newMainImage 商品主图 require false
     * @support  array $bannerUrl banner图 require false
     * @support  array $descriptionUrl 商品详情图 require false
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  array $categoryAttrs 商品分类属性 require false
     * @support  uint $outProductId 外部产品id require false
     * @support  string $source 外部产品的业务方, 存心：cunxin require false
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * productSkuBatchCreate
     *
     * @support  uint $productId 商品productId [ require true ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  array $productExtendMetric 商品productSku信息 [ require true ]
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuBatchCreate () {
        return self::getClass()->productSkuBatchCreate();
    }

    /**
     * productSkuBatchUpdate
     *
     * @support  uint $productId 商品productId [ require true ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  array $productExtendMetric 商品productSku信息 [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuBatchUpdate () {
        return self::getClass()->productSkuBatchUpdate();
    }

    /**
     * 删除productSku
     *
     * @param  uint $id 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuDelete (int $id) {
        return self::getClass()->productSkuDelete([
            "id" => $id,
        ]);
    }

    /**
     * 上架productSku
     *
     * @param  uint $id 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuUp (int $id) {
        return self::getClass()->productSkuUp([
            "id" => $id,
        ]);
    }

    /**
     * 下架productSku
     *
     * @param  uint $id 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuOff (int $id) {
        return self::getClass()->productSkuOff([
            "id" => $id,
        ]);
    }

    /**
     * 上架product
     *
     * @param  uint $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productUp (int $id) {
        return self::getClass()->productUp([
            "id" => $id,
        ]);
    }

    /**
     * 下架product
     *
     * @param  uint $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productOff (int $id) {
        return self::getClass()->productOff([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-不带productSku
     *
     * @param  uint $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-附带productSku
     *
     * @param  uint $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailWithSku (int $id) {
        return self::getClass()->detailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 根据产品id，仅获取product主要信息
     *
     * @param  uint $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductById (int $id) {
        return self::getClass()->getProductById([
            "id" => $id,
        ]);
    }

    /**
     * 根据产品productId，仅获取productSku主要信息
     *
     * @param  uint $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuByProductId (int $productId) {
        return self::getClass()->getProductSkuByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取productSku-分页
     *
     * @support  uint $id 商品productSKuId require false
     * @support  array $ids 商品productSKuIds require false
     * @support  uint $productId 商品productId require false
     * @support  array $productIds 商品productIds require false
     * @support  array $status productSku状态 require false
     * @support  string $skuName sku_name模糊搜索 require false
     * @support  int $page 第几页 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList();
    }

    /**
     * 获取productSku-不分页
     *
     * @support  uint $id 商品productSKuId require false
     * @support  array $ids 商品productSKuIds require false
     * @support  uint $productId 商品productId require false
     * @support  array $productIds 商品productIds require false
     * @support  array $status productSku状态 require false
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuAllList () {
        return self::getClass()->productSkuAllList();
    }

    /**
     * 获取产品分页列表-分页
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  int $groupId 商品分组id require false
     * @support  array $productIds 产品productIds require false
     * @support  string $name 名称(模糊查询) require false
     * @support  uint $categoryId 分类ID require false
     * @support  array $categoryIds 分类ID列表 require false
     * @support  uint $brandId 品牌ID require false
     * @support  array $status 状态 require false
     * @support  uint $onlineSales 预约端1/0 require false
     * @support  uint $offlineSales 门店端1/0 require false
     * @support  string $startAt 创建时间 require false
     * @support  string $endAt 更新时间 require false
     * @support  uint $needLabel 是否需要展示标签1/0 require false
     * @support  uint $isCombine 组合商品 require false
     * @param  uint $page 当前页 [ require true ]
     * @param  uint $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取产品分页列表-不分页
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  int $groupId 商品分组id require false
     * @support  array $productIds 产品productIds require false
     * @support  string $name 名称(模糊查询) require false
     * @support  uint $categoryId 分类ID require false
     * @support  array $categoryIds 分类ID列表 require false
     * @support  uint $brandId 品牌ID require false
     * @support  array $status 状态 require false
     * @support  uint $onlineSales 预约端1/0 require false
     * @support  uint $offlineSales 门店端1/0 require false
     * @support  string $startAt 创建时间 require false
     * @support  string $endAt 更新时间 require false
     * @support  uint $needLabel 是否需要展示标签1/0 require false
     * @support  uint $isCombine 组合商品 require false
     * @throws  \Exception
     * @return  array
     */
    public static function allList () {
        return self::getClass()->allList();
    }

    /**
     * 根据产品productId获取skus并按照sellPrice排序
     *
     * @param  array $productIds 商品分组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuByProductIdsOrderBySellPrice (array $productIds) {
        return self::getClass()->getSkuByProductIdsOrderBySellPrice([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 根据商品类型获取零售商场所有sku列表
     *
     * @param  uint $type 商品类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSkuByType (int $type) {
        return self::getClass()->getAllSkuByType([
            "type" => $type,
        ]);
    }

    /**
     * 根据productSku表的outSkuId,获取寸心对应的productSku信息
     *
     * @param  uint $outSkuId productSku表的outSkuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuCunXinByProductSkuOutSkuId (int $outSkuId) {
        return self::getClass()->getProductSkuCunXinByProductSkuOutSkuId([
            "outSkuId" => $outSkuId,
        ]);
    }

    /**
     * 根据productSku表的outSkuId,获取寸心对应的productSku信息
     *
     * @param  uint $productSkuId productSku表的Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuByProductSkuId (int $productSkuId) {
        return self::getClass()->getProductSkuByProductSkuId([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * 查询sku规格关联详情
     *
     * @support  array $productSkuIds productSku表的Ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuMetricItemsBySkuIds () {
        return self::getClass()->getSkuMetricItemsBySkuIds();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'ProductV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'ProductV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}