<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method allMetricsByParams(array $params)
 * @method listByParams(array $params)
 * @method moreMetricsItemListByParams(array $params)
 * @method metricItemDeleteByParams(array $params)
 * @method productSkuMetricItemListByParams(array $params)
 * @method productSkuMetricItemDeleteByParams(array $params)
 * @method productSkuMetricItemUpdateByParams(array $params)
 * @method productSkuMetricItemsListByParams(array $params)
 */
class Metric {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建规格
     *
     * @support  int $metricId 规格主表id [ require true ]
     * @support  array $itemList 规格详情 require false
     * @support  int $createdBy 创建人 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改规格
     *
     * @support  int $id 规格id [ require true ]
     * @support  string $name 规格详情 require false
     * @support  int $updateBy 更新人 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 全部规格分类
     *
     * @throws  \Exception
     * @return  array
     */
    public static function allMetrics () {
        return self::getClass()->allMetrics();
    }

    /**
     * 规格列表
     *
     * @support  int $metricId 规格主表id [ require true ]
     * @support  int $page 页数 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 多个规格列表
     *
     * @support  array $metricIds 规格主表id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function moreMetricsItemList () {
        return self::getClass()->moreMetricsItemList();
    }

    /**
     * 删除规格
     *
     * @support  int $id 规格id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function metricItemDelete () {
        return self::getClass()->metricItemDelete();
    }

    /**
     * 查询sku规格关联详情
     *
     * @support  array $productSkuIds 产品skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuMetricItemList () {
        return self::getClass()->productSkuMetricItemList();
    }

    /**
     * 删除sku规格关联
     *
     * @support  int $productSkuId 产品skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuMetricItemDelete () {
        return self::getClass()->productSkuMetricItemDelete();
    }

    /**
     * 更新sku规格关联
     *
     * @support  array $metric 度量子表id [ require true ]
     * @support  int $productSkuId 产品skuId [ require true ]
     * @support  int $createdBy 产品skuId [ require true ]
     * @support  int $updateBy 产品skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuMetricItemUpdate () {
        return self::getClass()->productSkuMetricItemUpdate();
    }

    /**
     * 查询productSku和metricItem的绑定关系
     *
     * @support  array $id product_sku_metric_item表的id require false
     * @support  array $ids product_sku_metric_item表的ids require false
     * @support  int $productSkuId 产品skuId require false
     * @support  array $productSkuIds 产品skuIds require false
     * @support  int $metricId 度量主表metricId require false
     * @support  array $metricIds 度量主表metricIds require false
     * @support  int $metricItemId 度量子表metricItemId require false
     * @support  array $metricItemIds 度量子表metricItemIds require false
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuMetricItemsList () {
        return self::getClass()->productSkuMetricItemsList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Metric');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Metric');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}