<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method updateExpressByParams(array $params)
 * @method shipInfoByParams(array $params)
 * @method shipProductListByParams(array $params)
 * @method allShipProductsByParams(array $params)
 * @method setShipProductFinishedByParams(array $params)
 * @method cancelShipProductFinishedByParams(array $params)
 * @method storeShipProductListByParams(array $params)
 */
class StoreShip {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加发货信息
     *
     * @param  int $staffId 录入伙伴id [ require true ]
     * @param  string $reason 下单原因 [ require true ]
     * @param  array $shipProducts 发货的产品明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $staffId, string $reason, array $shipProducts = []) {
        return self::getClass()->create([
            "staffId" => $staffId,
            "reason" => $reason,
            "shipProducts" => $shipProducts,
        ]);
    }

    /**
     * 删除发货单
     *
     * @param  int $id 发货id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取发货单列表
     *
     * @support  int $staffId 录入伙伴id require false
     * @support  string $status 状态 require false
     * @support  string $createTimeStart 创建开始时间 require false
     * @support  string $createTimeEnd 创建结束时间 require false
     * @support  bool $showDeleted 是否显示已删除信息 require false
     * @support  int $page 当前页 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 修改快递单号
     *
     * @param  int $id 发货id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  array $expressInfo 快递信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExpress (int $id, int $operateId, array $expressInfo) {
        return self::getClass()->updateExpress([
            "id" => $id,
            "operateId" => $operateId,
            "expressInfo" => $expressInfo,
        ]);
    }

    /**
     * 获取发货单基本信息
     *
     * @param  int $id 发货id [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shipInfo (int $id, bool $showDeleted = false) {
        return self::getClass()->shipInfo([
            "id" => $id,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 获取发货单商品列表
     *
     * @param  int $id 发货id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $productName 商品名称 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shipProductList (int $id, int $storeId = 0, string $productName = '', string $status = '', int $page = 0, int $pageSize = 20, bool $showDeleted = false) {
        return self::getClass()->shipProductList([
            "id" => $id,
            "storeId" => $storeId,
            "productName" => $productName,
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 获取发货单的所有商品
     *
     * @param  int $id 发货id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $productName 商品名称 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allShipProducts (int $id, int $storeId = 0, string $productName = '', string $status = '', bool $showDeleted = false) {
        return self::getClass()->allShipProducts([
            "id" => $id,
            "storeId" => $storeId,
            "productName" => $productName,
            "status" => $status,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 设置发货商品完成收货
     *
     * @param  int $id 发货商品id [ require true ]
     * @param  int $storeShipId 发货单id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setShipProductFinished (int $id, int $storeShipId, int $operateId) {
        return self::getClass()->setShipProductFinished([
            "id" => $id,
            "storeShipId" => $storeShipId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 撤回发货商品已完成状态
     *
     * @param  int $id 发货商品id [ require true ]
     * @param  int $storeShipId 发货单id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelShipProductFinished (int $id, int $storeShipId, int $operateId) {
        return self::getClass()->cancelShipProductFinished([
            "id" => $id,
            "storeShipId" => $storeShipId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取门店待收货列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $createTimeStart 发货单开始时间 require false
     * @support  string $createTimeEnd 发货单结束时间 require false
     * @support  string $express 快递单号 require false
     * @support  string $skuCode sku编码 require false
     * @support  string $productName 商品名称 require false
     * @support  array $statusList 状态 require false
     * @support  int $page 当前页 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeShipProductList () {
        return self::getClass()->storeShipProductList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'StoreShip');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'StoreShip');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}