<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method allByParams(array $params)
 * @method getByIdsByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建供应商
     *
     * @param  uint $createBy 创建人工号 [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  int $deliveryCycle 预计发货时间 [ require true ]
     * @param  string $code 供应商code [ require true ]
     * @param  string $domain 供应商域名 [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (int $createBy, string $name, int $deliveryCycle = 1, string $code, string $domain = '', string $remark = '') {
        return self::getClass()->create([
            "createBy" => $createBy,
            "name" => $name,
            "deliveryCycle" => $deliveryCycle,
            "code" => $code,
            "domain" => $domain,
            "remark" => $remark,
        ]);
    }

    /**
     * 修改供应商
     *
     * @param  uint $id id [ require true ]
     * @param  uint $updateBy 创建人工号 [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  int $deliveryCycle 预计发货时间 [ require true ]
     * @param  string $domain 供应商域名 [ require true ]
     * @param  string $remark 类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, int $updateBy, string $name, int $deliveryCycle = 1, string $domain = '', string $remark = '') {
        return self::getClass()->update([
            "id" => $id,
            "updateBy" => $updateBy,
            "name" => $name,
            "deliveryCycle" => $deliveryCycle,
            "domain" => $domain,
            "remark" => $remark,
        ]);
    }

    /**
     * 供应商列表
     *
     * @param  string $name 名称 [ require true ]
     * @param  uint $page 页码 [ require true ]
     * @param  uint $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除供应商
     *
     * @param  uint $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 所有供应商
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $name = '') {
        return self::getClass()->all([
            "name" => $name,
        ]);
    }

    /**
     * 根据ids获取供应商
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIds (array $ids) {
        return self::getClass()->getByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}