<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStateByParams(array $params)
 * @method saveByParams(array $params)
 * @method historyByParams(array $params)
 * @method getSkuListByParams(array $params)
 */
class ProjectCollect {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店收集状态
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getState (int $storeId) {
        return self::getClass()->getState([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 门店填写收集
     *
     * @support  int $project_id 计划ID [ require true ]
     * @support  array $sku_info 关联sku [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save () {
        return self::getClass()->save();
    }

    /**
     * 门店历史信息收集
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  string $name 名称(模糊查询) require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function history (int $page = 1, int $pageSize = 20) {
        return self::getClass()->history([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 计划包含的SKU
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $project_id 计划ID [ require true ]
     * @support  string $skuName SKU名称(模糊查询) require false
     * @support  int $categoryId 类目ID require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getSkuList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'ProjectCollect');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'ProjectCollect');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}