<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method productSkuCreateByParams(array $params)
 * @method productSkuBatchCreateByParams(array $params)
 * @method productSkuUpdateByParams(array $params)
 * @method productSkuBatchUpdateByParams(array $params)
 * @method productSkuDeleteByParams(array $params)
 * @method productSkuUpByParams(array $params)
 * @method productSkuOffByParams(array $params)
 * @method productUpByParams(array $params)
 * @method productOffByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailWithSkuByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method productSkuAllListByParams(array $params)
 * @method listByParams(array $params)
 * @method allListByParams(array $params)
 * @method getSkuByProductIdsOrderBySellPriceByParams(array $params)
 */
class ProductV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3门店定制商品，4商城定制产品 [Original type uint] 
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $newMainImage 商品主图 
     * @support  array $bannerUrl banner图 
     * @support  array $descriptionUrl 商品详情图 
     * @support  int $needCheckStock 是否需要盘点,0不需要要，1需要 [Original type uint] 
     * @support  array $categoryAttrs 商品分类属性 
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新产品
     *
     * @support  int $id 产品id [Original type uint] [ require true ]
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3定制商品 [Original type uint] 
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  int $groupId 分组ID [Original type uint] 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $newMainImage 商品主图 
     * @support  array $bannerUrl banner图 
     * @support  array $descriptionUrl 商品详情图 
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  array $categoryAttrs 商品分类属性 
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 创建productSku
     *
     * @support  int $productId 商品productId [Original type uint] [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  array $metric 商品规格 [ require true ]
     * @support  string $image SKU图片 [ require true ]
     * @support  array $otherRelateCodes 其他编码 
     * @support  float $costPrice 成本价（P1） [Original type double] [ require true ]
     * @support  float $franchiseePrice 加盟商价（P2） [Original type double] 
     * @support  float $originalPrice 牌价（P3） [Original type double] [ require true ]
     * @support  float $sellPrice 现价 [Original type double] 
     * @support  array $sellChannel 销售渠道 [ require true ]
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuCreate () {
        return self::getClass()->productSkuCreate();
    }

    /**
     * productSkuBatchCreate
     *
     * @support  int $productId 商品productId [Original type uint] [ require true ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  int $createBy 创建人ID [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuBatchCreate () {
        return self::getClass()->productSkuBatchCreate();
    }

    /**
     * 更新productSku
     *
     * @support  int $id 商品productSkuId [Original type uint] [ require true ]
     * @support  int $productId 商品productId [Original type uint] [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  array $metric 商品规格 [ require true ]
     * @support  string $image SKU图片 [ require true ]
     * @support  array $otherRelateCodes 其他编码 
     * @support  float $costPrice 成本价（P1） [Original type double] [ require true ]
     * @support  float $franchiseePrice 加盟商价（P2） [Original type double] 
     * @support  float $originalPrice 牌价（P3） [Original type double] [ require true ]
     * @support  float $sellPrice 现价 [Original type double] 
     * @support  array $sellChannel 销售渠道 [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuUpdate () {
        return self::getClass()->productSkuUpdate();
    }

    /**
     * productSkuBatchUpdate
     *
     * @support  int $productId 商品productId [Original type uint] [ require true ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  int $updateBy 更新人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuBatchUpdate () {
        return self::getClass()->productSkuBatchUpdate();
    }

    /**
     * 删除productSku
     *
     * @param  int $id 商品productSkuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuDelete (int $id) {
        return self::getClass()->productSkuDelete([
            "id" => $id,
        ]);
    }

    /**
     * 上架productSku
     *
     * @param  int $id 商品productSkuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuUp (int $id) {
        return self::getClass()->productSkuUp([
            "id" => $id,
        ]);
    }

    /**
     * 下架productSku
     *
     * @param  int $id 商品productSkuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuOff (int $id) {
        return self::getClass()->productSkuOff([
            "id" => $id,
        ]);
    }

    /**
     * 上架product
     *
     * @param  int $id 商品productId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productUp (int $id) {
        return self::getClass()->productUp([
            "id" => $id,
        ]);
    }

    /**
     * 下架product
     *
     * @param  int $id 商品productId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productOff (int $id) {
        return self::getClass()->productOff([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-不带productSku
     *
     * @param  int $id 商品productId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-附带productSku
     *
     * @param  int $id 商品productId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailWithSku (int $id) {
        return self::getClass()->detailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 获取productSku-分页
     *
     * @support  int $id 商品productSKuId [Original type uint] 
     * @support  array $ids 商品productSKuIds 
     * @support  int $productId 商品productId [Original type uint] 
     * @support  array $productIds 商品productIds 
     * @support  array $status productSku状态 
     * @support  int $page 第几页 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList();
    }

    /**
     * 获取productSku-不分页
     *
     * @support  int $id 商品productSKuId [Original type uint] 
     * @support  array $ids 商品productSKuIds 
     * @support  int $productId 商品productId [Original type uint] 
     * @support  array $productIds 商品productIds 
     * @support  array $status productSku状态 
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuAllList () {
        return self::getClass()->productSkuAllList();
    }

    /**
     * 获取产品分页列表-分页
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 
     * @support  int $groupId 商品分组id 
     * @support  array $productIds 产品productIds 
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID [Original type uint] 
     * @support  array $categoryIds 分类ID列表 
     * @support  int $brandId 品牌ID [Original type uint] 
     * @support  array $status 状态 
     * @support  int $onlineSales 预约端1/0 [Original type uint] 
     * @support  int $offlineSales 门店端1/0 [Original type uint] 
     * @support  string $startAt 创建时间 
     * @support  string $endAt 更新时间 
     * @support  int $needLabel 是否需要展示标签1/0 [Original type uint] 
     * @support  int $isCombine 组合商品 [Original type uint] 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取产品分页列表-不分页
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 
     * @support  int $groupId 商品分组id 
     * @support  array $productIds 产品productIds 
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID [Original type uint] 
     * @support  array $categoryIds 分类ID列表 
     * @support  int $brandId 品牌ID [Original type uint] 
     * @support  array $status 状态 
     * @support  int $onlineSales 预约端1/0 [Original type uint] 
     * @support  int $offlineSales 门店端1/0 [Original type uint] 
     * @support  string $startAt 创建时间 
     * @support  string $endAt 更新时间 
     * @support  int $needLabel 是否需要展示标签1/0 [Original type uint] 
     * @support  int $isCombine 组合商品 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function allList () {
        return self::getClass()->allList();
    }

    /**
     * 根据产品productId获取skus并按照sellPrice排序
     *
     * @param  array $productIds 商品分组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuByProductIdsOrderBySellPrice (array $productIds) {
        return self::getClass()->getSkuByProductIdsOrderBySellPrice([
            "productIds" => $productIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'ProductV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'ProductV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}