<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method bindProductAndGroupByParams(array $params)
 */
class Group {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建分组
     *
     * @support  string $name 分组名称 [ require true ]
     * @support  string $imageUrl 分组图片 
     * @support  string $showPlace 展示位置index_list,index_banner 
     * @support  int $sort 排序值，default=0 
     * @support  int $createdBy 创建人 [ require true ]
     * @support  int $updatedBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新分组
     *
     * @support  int $id 分组id [ require true ]
     * @support  string $name 分组名称 [ require true ]
     * @support  string $imageUrl 分组图片 
     * @support  string $showPlace 展示位置index_list,index_banner 
     * @support  int $sort 排序值，default=0 
     * @support  int $updatedBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除分组
     *
     * @param  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取分组列表
     *
     * @support  string $showPlace 展示位置index_list,index_banner 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品分组和product绑定
     *
     * @support  int $groupId 分组id [ require true ]
     * @support  int $productId 产品Id [ require true ]
     * @support  int $createdBy 创建人 [ require true ]
     * @support  int $updatedBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductAndGroup () {
        return self::getClass()->bindProductAndGroup();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Group');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Group');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}