<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method noticeCategoryListBySourceByParams(array $params)
 * @method noticeCategoryListByParams(array $params)
 * @method noticeListByParams(array $params)
 * @method noticeDetailByParams(array $params)
 * @method lastHonorNoticeDetailByParams(array $params)
 * @method noticeCategoryByNoticeCategoryIdByParams(array $params)
 * @method deleteNoticeByParams(array $params)
 */
class Notice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建公告
     *
     * @support  int $noticeCategoryId 板块id [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 正文 [ require true ]
     * @support  array $noticeAnnex 附件信息 
     * @support  int $createBy 创建人 
     * @support  int $updateBy 修改人 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑公告
     *
     * @support  int $id 公告id [ require true ]
     * @support  int $noticeCategoryId 板块id [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 正文 [ require true ]
     * @support  array $noticeAnnex 附件信息 
     * @support  int $createBy 创建人 
     * @support  int $updateBy 修改人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取公告板块列表名称
     *
     * @param  int $source 分类类型1普通公告，2荣耀榜单 [ require true ]
     * @param  int $scene 公告场景retail零售，operate运营 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function noticeCategoryListBySource (int $source, int $scene) {
        return self::getClass()->noticeCategoryListBySource([
            "source" => $source,
            "scene" => $scene,
        ]);
    }

    /**
     * 获取公告板块列表名称
     *
     * @support  int $scene 公告场景retail零售，operate运营 
     * @throws  \Exception
     * @return  array
     */
    public static function noticeCategoryList () {
        return self::getClass()->noticeCategoryList();
    }

    /**
     * 公告列表查询
     *
     * @support  int $noticeCategoryId 公告板块类别 
     * @support  string $title 标题 
     * @support  string $publishAtBegin 发布时间开始 
     * @support  string $publishAtEnd 发布时间结束 
     * @support  int $page 页数 
     * @support  int $pageSize 每页条数 
     * @support  int $userId 登录人userId 
     * @throws  \Exception
     * @return  mixed
     */
    public static function noticeList () {
        return self::getClass()->noticeList();
    }

    /**
     * 公告详情
     *
     * @support  int $id 公告id [ require true ]
     * @support  int $userId 公告id 
     * @throws  \Exception
     * @return  array
     */
    public static function noticeDetail () {
        return self::getClass()->noticeDetail();
    }

    /**
     * 获取最新的一篇荣耀榜公告
     *
     * @support  int $userId 公告id 
     * @throws  \Exception
     * @return  array
     */
    public static function lastHonorNoticeDetail () {
        return self::getClass()->lastHonorNoticeDetail();
    }

    /**
     * 根据公告板块id，查询板块信息
     *
     * @param  int $noticeCategoryId 公告分类板块id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function noticeCategoryByNoticeCategoryId (int $noticeCategoryId) {
        return self::getClass()->noticeCategoryByNoticeCategoryId([
            "noticeCategoryId" => $noticeCategoryId,
        ]);
    }

    /**
     * 删除公告
     *
     * @param  int $id 公告id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteNotice (int $id) {
        return self::getClass()->deleteNotice([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Notice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Notice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}