<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method setSellPriceByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method getSkuBySkuCodeByParams(array $params)
 * @method judgeProductOfStoreByParams(array $params)
 * @method getSkuInfoByParams(array $params)
 * @method getSkuBySkuIdsByParams(array $params)
 * @method getNeedInventoryCheckSkuByParams(array $params)
 * @method getInventoryCheckSkuListByParams(array $params)
 * @method getAllSkuByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 * @method setProductStoreGroupByParams(array $params)
 * @method getProductStoreGroupByParams(array $params)
 * @method deleteProductStoreGroupByParams(array $params)
 * @method updateSkuByParams(array $params)
 * @method createSkuGroupByParams(array $params)
 * @method updateSkuGroupByParams(array $params)
 * @method deleteSkuGroupByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  int $brandId 分类ID [Original type uint] [ require true ]
     * @support  array $categoryAttrs 商品分类属性 
     * @support  array $skus 商品skus [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @support  int $offlineSales 门店端销售商品 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 编辑产品基本信息
     *
     * @param  int $id 产品id [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  int $categoryId 分类ID [Original type uint] [ require true ]
     * @param  int $brandId 分类ID [Original type uint] [ require true ]
     * @support  array $categoryAttrs 产品主图 
     * @param  int $supplierId 供应商id [Original type uint] [ require true ]
     * @param  bool $needCheckStock 是否需要盘点 [ require true ]
     * @param  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @param  int $offlineSales 门店端销售商品 [ require true ]
     * @support  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $categoryId, int $onlineSales, int $offlineSales, string $name, int $brandId = NULL, int $supplierId = 0, bool $needCheckStock = false) {
        return self::getClass()->update([
            "id" => $id,
            "categoryId" => $categoryId,
            "onlineSales" => $onlineSales,
            "offlineSales" => $offlineSales,
            "name" => $name,
            "brandId" => $brandId,
            "supplierId" => $supplierId,
            "needCheckStock" => $needCheckStock,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID [Original type uint] 
     * @support  int $brandId 品牌ID [Original type uint] 
     * @support  string $status 状态 
     * @support  int $onlineSales 预约端1/0 [Original type uint] 
     * @support  int $offlineSales 门店端1/0 [Original type uint] 
     * @support  string $startAt 创建时间 
     * @support  string $endAt 更新时间 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id, int $operateId) {
        return self::getClass()->up([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function off (int $id, int $operateId) {
        return self::getClass()->off([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 配置sku的现价/售价
     *
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSellPrice (array $data) {
        return self::getClass()->setSellPrice([
            "data" => $data,
        ]);
    }

    /**
     * 设置产品标签
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @param  array $tags 标签:new新品,major重点,main主推,清货clear [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setTags (int $id, array $tags) {
        return self::getClass()->setTags([
            "id" => $id,
            "tags" => $tags,
        ]);
    }

    /**
     * 根据编码获取sku信息
     *
     * @param  string $skuCode 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuCode (string $skuCode) {
        return self::getClass()->getSkuBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * 校验零售商品是否在店铺中
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function judgeProductOfStore (int $id, int $storeId) {
        return self::getClass()->judgeProductOfStore([
            "id" => $id,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取sku详情
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfo (int $skuId, string $from, bool $withOffSku = false) {
        return self::getClass()->getSkuInfo([
            "skuId" => $skuId,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 根据skuIds获取详情
     *
     * @param  array $skuIds skuIds [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuIds (array $skuIds, string $from, bool $withOffSku = false) {
        return self::getClass()->getSkuBySkuIds([
            "skuIds" => $skuIds,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNeedInventoryCheckSku (bool $withOffSku = false) {
        return self::getClass()->getNeedInventoryCheckSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku列表
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  int $categoryId 分类id [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventoryCheckSkuList (int $storeId, int $categoryId = 0, int $page = 1, int $pageSize = 20, bool $withOffSku = false) {
        return self::getClass()->getInventoryCheckSkuList([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
            "page" => $page,
            "pageSize" => $pageSize,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取所有的sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSku (bool $withOffSku = false) {
        return self::getClass()->getAllSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * 配置门店组
     *
     * @param  array $ids 商品ids [ require true ]
     * @param  array $storeGroupIds 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取产品对应门店组
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductStoreGroup (int $id) {
        return self::getClass()->getProductStoreGroup([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品对应门店组
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @param  array $groupId 分组id [ require true ]
     * @param  array $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductStoreGroup (int $id, array $groupId, array $storeId) {
        return self::getClass()->deleteProductStoreGroup([
            "id" => $id,
            "groupId" => $groupId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 修改sku信息
     *
     * @param  int $skuId sku id [Original type uint] [ require true ]
     * @param  array $skus sku信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSku (int $skuId, array $skus) {
        return self::getClass()->updateSku([
            "skuId" => $skuId,
            "skus" => $skus,
        ]);
    }

    /**
     * 添加组合信息
     *
     * @param  int $relationId sku的关联id [Original type uint] [ require true ]
     * @param  int $skuId sku id [Original type uint] [ require true ]
     * @param  int $count 数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSkuGroup (int $relationId, int $skuId, int $count) {
        return self::getClass()->createSkuGroup([
            "relationId" => $relationId,
            "skuId" => $skuId,
            "count" => $count,
        ]);
    }

    /**
     * 更新组合信息
     *
     * @param  int $relationId sku的关联id [Original type uint] [ require true ]
     * @param  int $skuId sku id [Original type uint] [ require true ]
     * @param  int $count 数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSkuGroup (int $relationId, int $skuId, int $count) {
        return self::getClass()->updateSkuGroup([
            "relationId" => $relationId,
            "skuId" => $skuId,
            "count" => $count,
        ]);
    }

    /**
     * deleteSkuGroup
     *
     * @param  int $relationId sku的关联id [Original type uint] [ require true ]
     * @param  int $skuId sku id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSkuGroup (int $relationId, int $skuId) {
        return self::getClass()->deleteSkuGroup([
            "relationId" => $relationId,
            "skuId" => $skuId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}