<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Specification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建规格
     *
     * @param  int $createBy 创建人工号 [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $createBy, string $name, string $type, string $code) {
        return self::getClass()->create([
            "createBy" => $createBy,
            "name" => $name,
            "type" => $type,
            "code" => $code,
        ]);
    }

    /**
     * 修改规格
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  int $updateBy 创建人工号 [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $updateBy, string $name, string $type, string $code) {
        return self::getClass()->update([
            "id" => $id,
            "updateBy" => $updateBy,
            "name" => $name,
            "type" => $type,
            "code" => $code,
        ]);
    }

    /**
     * 批量处理
     *
     * @param  int $updateBy 创建人工号 [Original type uint] [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  array $info 规格信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (int $updateBy, string $type, array $info) {
        return self::getClass()->batchUpdate([
            "updateBy" => $updateBy,
            "type" => $type,
            "info" => $info,
        ]);
    }

    /**
     * 规格列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除规格
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Specification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Specification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}