<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method batchRemoveByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method treeByParams(array $params)
 * @method getCategoriesWithAllLastCategoryNameByParams(array $params)
 * @method updateSortByParams(array $params)
 * @method getPropertiesByIdByParams(array $params)
 * @method batchCreateCategoryByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @param  string $name 类目名称 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @param  int $parentId 父级类目id [ require true ]
     * @param  array $property 属性 [ require true ]
     * @param  array $lifecycle 生命周期 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (string $name, string $code = '', int $parentId = 0, array $property = [], array $lifecycle = [], int $operateId = 0) {
        return self::getClass()->create([
            "name" => $name,
            "code" => $code,
            "parentId" => $parentId,
            "property" => $property,
            "lifecycle" => $lifecycle,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 更新类目
     *
     * @param  int $id 类目ID [ require true ]
     * @param  string $name 类目名称 [ require true ]
     * @param  string $code 编码 [ require true ]
     * @param  int $sort 排序值 [ require true ]
     * @param  array $property 属性 [ require true ]
     * @param  array $lifecycle 生命周期 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $name, string $code = '', int $operateId = 0, int $sort = 0, array $property = [], array $lifecycle = []) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "code" => $code,
            "operateId" => $operateId,
            "sort" => $sort,
            "property" => $property,
            "lifecycle" => $lifecycle,
        ]);
    }

    /**
     * 批量创建类目
     *
     * @param  array $data 类目数组 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data, int $operateId = 0) {
        return self::getClass()->batchCreate([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量更新类目
     *
     * @param  array $data 类目数组 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data, int $operateId = 0) {
        return self::getClass()->batchUpdate([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取类目详情
     *
     * @param  int $id 类目ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, bool $showDeleted = false) {
        return self::getClass()->detail([
            "id" => $id,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 类目ID [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId = 0) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量删除
     *
     * @param  array $ids 类目IDS [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchRemove (array $ids, int $operateId = 0) {
        return self::getClass()->batchRemove([
            "ids" => $ids,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 20, int $storeId = 0, bool $showDeleted = false) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "storeId" => $storeId,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  array $ids 类目id数据 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $storeId = 0, array $ids = [], bool $showDeleted = false) {
        return self::getClass()->all([
            "storeId" => $storeId,
            "ids" => $ids,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 类目树
     *
     * @param  bool $withDeleted 带上软删除的数据 [ require true ]
     * @param  int $parentId 父级id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function tree (int $parentId = 0, bool $withDeleted = false) {
        return self::getClass()->tree([
            "parentId" => $parentId,
            "withDeleted" => $withDeleted,
        ]);
    }

    /**
     * 获取分类信息以及所有上级分类的名称
     *
     * @param  array $ids 类目ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoriesWithAllLastCategoryName (array $ids = []) {
        return self::getClass()->getCategoriesWithAllLastCategoryName([
            "ids" => $ids,
        ]);
    }

    /**
     * 更改排序
     *
     * @param  int $id 品类id [Original type uint] [ require true ]
     * @param  int $sort 排序值 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSort (int $id, int $sort) {
        return self::getClass()->updateSort([
            "id" => $id,
            "sort" => $sort,
        ]);
    }

    /**
     * 根据品类id获取属性信息
     *
     * @param  int $id 品类id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPropertiesById (int $id) {
        return self::getClass()->getPropertiesById([
            "id" => $id,
        ]);
    }

    /**
     * 批量导入品类
     *
     * @param  array $info 商品信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreateCategory (array $info) {
        return self::getClass()->batchCreateCategory([
            "info" => $info,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}