<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method removeByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkuProductServiceByProductIdByParams(array $params)
 * @method getRetailSkuProductServiceByProductIdByParams(array $params)
 */
class SkuProductService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄产品添加sku
     *
     * @param  int $productId 产品服务的产品id [ require true ]
     * @param  array $skuIds 零售商品的skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $productId, array $skuIds) {
        return self::getClass()->create([
            "productId" => $productId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 更新拍摄产品的sku
     *
     * @param  int $productId 产品服务的产品id [ require true ]
     * @param  array $skuIds 零售商品的skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $productId, array $skuIds) {
        return self::getClass()->update([
            "productId" => $productId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 删除sku的拍摄产品
     *
     * @param  int $productId 产品服务的产品id [ require true ]
     * @param  array $skuIds 零售商品的skuIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $productId, array $skuIds = []) {
        return self::getClass()->remove([
            "productId" => $productId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 获取sku关联的拍摄产品
     *
     * @param  int $productId 产品服务的产品id [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @param  int $onlineSale 是否线上销售:1 是 0 否 [ require true ]
     * @param  array $skuIds 零售商品的skuIds [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $productId, bool $withOffSku = false, array $skuIds = [], int $onlineSale = 1, int $storeId = 0) {
        return self::getClass()->detail([
            "productId" => $productId,
            "withOffSku" => $withOffSku,
            "skuIds" => $skuIds,
            "onlineSale" => $onlineSale,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 根据拍摄服务的产品id获取sku的拍摄服务
     *
     * @param  int $productId 产品服务的产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuProductServiceByProductId (int $productId) {
        return self::getClass()->getSkuProductServiceByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * 根据拍摄产品的productId获取其绑定的零售产品skuId
     *
     * @param  int $productId 拍摄产品的productId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetailSkuProductServiceByProductId (int $productId) {
        return self::getClass()->getRetailSkuProductServiceByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'SkuProductService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'SkuProductService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}