<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createGroupByParams(array $params)
 * @method updateGroupByParams(array $params)
 * @method groupListByParams(array $params)
 * @method allGroupByParams(array $params)
 * @method groupDetailByParams(array $params)
 * @method createLabelByParams(array $params)
 * @method updateLabelByParams(array $params)
 * @method labelListByParams(array $params)
 * @method allLabelByParams(array $params)
 * @method labelDetailByParams(array $params)
 */
class SkuAttribute {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加sku的规格名
     *
     * @param  string $name 规格名称 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createGroup (string $name, int $sort = 0) {
        return self::getClass()->createGroup([
            "name" => $name,
            "sort" => $sort,
        ]);
    }

    /**
     * 修改sku的规格名
     *
     * @param  int $id id [ require true ]
     * @param  string $name 规格名称 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateGroup (int $id, string $name, int $sort = 0) {
        return self::getClass()->updateGroup([
            "id" => $id,
            "name" => $name,
            "sort" => $sort,
        ]);
    }

    /**
     * 规格名列表
     *
     * @param  string $name 规格名称 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupList (int $page = 1, int $pageSize = 20, string $name = '') {
        return self::getClass()->groupList([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
        ]);
    }

    /**
     * 获取所有规格名
     *
     * @param  string $name 规格名称 [ require true ]
     * @param  bool $withLabel 是否需要规格值 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allGroup (string $name = '', bool $withLabel = false) {
        return self::getClass()->allGroup([
            "name" => $name,
            "withLabel" => $withLabel,
        ]);
    }

    /**
     * 获取规格名详情
     *
     * @param  int $id id [ require true ]
     * @param  bool $withProduct 是否显示商品信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function groupDetail (int $id, bool $withProduct = false) {
        return self::getClass()->groupDetail([
            "id" => $id,
            "withProduct" => $withProduct,
        ]);
    }

    /**
     * 添加sku的规格值
     *
     * @param  string $name 规格值名称 [ require true ]
     * @param  int $groupId 规格名id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createLabel (int $groupId, string $name) {
        return self::getClass()->createLabel([
            "groupId" => $groupId,
            "name" => $name,
        ]);
    }

    /**
     * 修改sku的规格值
     *
     * @param  int $id id [ require true ]
     * @param  string $name 规格值名称 [ require true ]
     * @param  int $groupId 规格名id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateLabel (int $id, string $name, int $groupId = 0) {
        return self::getClass()->updateLabel([
            "id" => $id,
            "name" => $name,
            "groupId" => $groupId,
        ]);
    }

    /**
     * 规格值列表
     *
     * @param  string $name 规格值名称 [ require true ]
     * @param  int $groupId 规格名id [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function labelList (int $groupId = 0, int $page = 1, int $pageSize = 20, string $name = '') {
        return self::getClass()->labelList([
            "groupId" => $groupId,
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
        ]);
    }

    /**
     * 获取所有规格值
     *
     * @param  string $name 规格值名称 [ require true ]
     * @param  int $groupId 规格名id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allLabel (int $groupId = 0, string $name = '') {
        return self::getClass()->allLabel([
            "groupId" => $groupId,
            "name" => $name,
        ]);
    }

    /**
     * 获取所有规格值
     *
     * @param  int $id id [ require true ]
     * @param  bool $withProduct 是否显示商品信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function labelDetail (int $id, bool $withProduct = false) {
        return self::getClass()->labelDetail([
            "id" => $id,
            "withProduct" => $withProduct,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'SkuAttribute');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'SkuAttribute');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}