<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateStoreToGroupByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method bindingStoreByParams(array $params)
 * @method listByParams(array $params)
 * @method listWithStoreByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method allByParams(array $params)
 */
class StoreGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时同步门店组相关门店(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStoreToGroup () {
        return self::getClass()->updateStoreToGroup();
    }

    /**
     * 创建分组
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @param  array $rule 规则 [ require true ]
     * @param  array $whitelist 白名单 [ require true ]
     * @param  array $blacklist 黑名单 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (string $name, int $operateId = 0, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return self::getClass()->create([
            "name" => $name,
            "operateId" => $operateId,
            "remark" => $remark,
            "rule" => $rule,
            "whitelist" => $whitelist,
            "blacklist" => $blacklist,
        ]);
    }

    /**
     * 修改分组名
     *
     * @param  int $id 类目ID [ require true ]
     * @param  string $name 分组名称 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @param  array $rule 规则 [ require true ]
     * @param  array $whitelist 白名单 [ require true ]
     * @param  array $blacklist 黑名单 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, int $operateId = 0, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "operateId" => $operateId,
            "remark" => $remark,
            "rule" => $rule,
            "whitelist" => $whitelist,
            "blacklist" => $blacklist,
        ]);
    }

    /**
     * 绑定店铺
     *
     * @param  int $id 分组id [Original type uint] [ require true ]
     * @param  string $name 分组名称 [ require true ]
     * @param  array $storeIds 店铺ids [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindingStore (int $id, int $operateId, string $name, array $storeIds = []) {
        return self::getClass()->bindingStore([
            "id" => $id,
            "operateId" => $operateId,
            "name" => $name,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取分组列表
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 20) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取分组列表含门店
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithStore (string $name = '', int $page = 1, int $pageSize = 20) {
        return self::getClass()->listWithStore([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取分组的详情
     *
     * @param  int $id 分组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除分组
     *
     * @param  int $id 分组id [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取全部门店组数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'StoreGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'StoreGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}