<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setInventoryByParams(array $params)
 */
class StoreProductInventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 绑定门店回调监听
     *
     * @param  string $type 出入库类型 [ require true ]
     * @param  int $staffId 操作人id [Original type uint] [ require true ]
     * @param  string $inventoryType 库存操作方式:out_of_stock 出库 warehousing:入库 [ require true ]
     * @param  array $data 详细数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setInventory (int $staffId, string $type, string $inventoryType, array $data) {
        return self::getClass()->setInventory([
            "staffId" => $staffId,
            "type" => $type,
            "inventoryType" => $inventoryType,
            "data" => $data,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'StoreProductInventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'StoreProductInventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}