<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method getProductListWithSkusByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method getSkuInfoByParams(array $params)
 * @method setSellPriceByParams(array $params)
 * @method setTagsByParams(array $params)
 * @method batchSetTagsByParams(array $params)
 * @method getTagStatusByParams(array $params)
 * @method getTagProductListByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 * @method getSkuBySkuCodeByParams(array $params)
 * @method setProductStoreGroupByParams(array $params)
 * @method getProductStoreGroupByParams(array $params)
 * @method deleteProductStoreGroupByParams(array $params)
 * @method updateSkuByParams(array $params)
 * @method getSkuGroupByParams(array $params)
 * @method batchUpdateSkuImageByParams(array $params)
 * @method batchCreateProductByParams(array $params)
 * @method getMessageLogByParams(array $params)
 * @method getSkuBySkuIdsByParams(array $params)
 * @method getNeedInventoryCheckSkuByParams(array $params)
 * @method getInventoryCheckSkuListByParams(array $params)
 * @method getAllSkuByParams(array $params)
 * @method allByParams(array $params)
 * @method getStoreIdsByProductIdByParams(array $params)
 * @method getProductSkusAndSpecificationsByIdByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  int $brandId 分类ID [Original type uint] [ require true ]
     * @support  array $categoryAttrs 商品分类属性 
     * @support  array $skus 商品skus [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] 
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 [ require true ]
     * @support  int $offlineSales 门店端销售商品 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 编辑产品基本信息
     *
     * @param  int $id 产品id [ require true ]
     * @support  string $name 产品名称 
     * @support  int $categoryId 分类ID [Original type uint] 
     * @support  int $brandId 分类ID [Original type uint] 
     * @support  array $categoryAttrs 产品主图 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @support  bool $needCheckStock 是否需要盘点 
     * @support  int $onlineSales 预约端销售商品:1 是 0 否 
     * @support  int $offlineSales 门店端销售商品 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $operateId = 0) {
        return self::getClass()->update([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  string $status 产品状态 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $from 来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $from, int $storeId = 0, string $status = '') {
        return self::getClass()->detail([
            "id" => $id,
            "from" => $from,
            "storeId" => $storeId,
            "status" => $status,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID [Original type uint] 
     * @support  int $brandId 品牌ID [Original type uint] 
     * @support  array $status 状态 
     * @support  int $onlineSales 预约端1/0 [Original type uint] 
     * @support  int $offlineSales 门店端1/0 [Original type uint] 
     * @support  string $startAt 创建时间 
     * @support  string $endAt 更新时间 
     * @support  int $needLabel 是否需要展示标签1/0 [Original type uint] 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取商品s(门店端)
     *
     * @support  array $storeIds 门店ids 
     * @support  string $name 名称 
     * @support  array $categoryIds 品类ids 
     * @support  array $status 状态 
     * @support  string $skuCode sku编码 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListWithSkus (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductListWithSkus([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id, int $operateId) {
        return self::getClass()->up([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function off (int $id, int $operateId) {
        return self::getClass()->off([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取sku详情
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfo (int $skuId, string $from, bool $withOffSku = false) {
        return self::getClass()->getSkuInfo([
            "skuId" => $skuId,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 配置sku的现价/售价
     *
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setSellPrice (array $data) {
        return self::getClass()->setSellPrice([
            "data" => $data,
        ]);
    }

    /**
     * 设置产品标签
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @param  array $tags 标签:new新品,major重点,main主推,清货clear [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setTags (int $id, array $tags = []) {
        return self::getClass()->setTags([
            "id" => $id,
            "tags" => $tags,
        ]);
    }

    /**
     * 批量设置产品标签
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @param  array $updateTags 二维数组[标签id,开始时间startAt,结束时间endAt] [ require true ]
     * @param  array $delTags [标签id,标签id] [ require true ]
     * @param  int $operateId 操作人工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSetTags (array $ids, array $updateTags = [], array $delTags = [], int $operateId) {
        return self::getClass()->batchSetTags([
            "ids" => $ids,
            "updateTags" => $updateTags,
            "delTags" => $delTags,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据产品id获取标签状态
     *
     * @param  array $ids 产品id列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTagStatus (array $ids) {
        return self::getClass()->getTagStatus([
            "ids" => $ids,
        ]);
    }

    /**
     * 标签产品列表
     *
     * @support  int $tagId 标签id [ require true ]
     * @support  string $productName 产品名称 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTagProductList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTagProductList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * 根据编码获取sku信息
     *
     * @param  string $skuCode 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuCode (string $skuCode) {
        return self::getClass()->getSkuBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * 配置门店组
     *
     * @param  array $ids 商品ids [ require true ]
     * @param  array $storeGroupIds 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取产品对应门店组
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductStoreGroup (int $id) {
        return self::getClass()->getProductStoreGroup([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品对应门店组
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @param  int $groupId 分组id [Original type uint] [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductStoreGroup (int $id, int $groupId = 0, int $storeId = 0) {
        return self::getClass()->deleteProductStoreGroup([
            "id" => $id,
            "groupId" => $groupId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 修改sku信息
     *
     * @param  int $productId 商品id [Original type uint] [ require true ]
     * @param  array $skus sku信息 [ require true ]
     * @param  array $groups 组合sku信息 [ require true ]
     * @param  int $operateId 操作人ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSku (int $productId, array $skus, array $groups, int $operateId) {
        return self::getClass()->updateSku([
            "productId" => $productId,
            "skus" => $skus,
            "groups" => $groups,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取组合的sku信息
     *
     * @param  int $relationId sku的关联id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuGroup (int $relationId) {
        return self::getClass()->getSkuGroup([
            "relationId" => $relationId,
        ]);
    }

    /**
     * 批量修改sku图片
     *
     * @param  string $type name,code根据名称,编码匹配 [ require true ]
     * @param  array $info 待匹配的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdateSkuImage (string $type, array $info) {
        return self::getClass()->batchUpdateSkuImage([
            "type" => $type,
            "info" => $info,
        ]);
    }

    /**
     * 批量上传商品
     *
     * @param  int $operateId 操作人工号 [Original type uint] [ require true ]
     * @param  array $info 待匹配的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreateProduct (int $operateId, array $info) {
        return self::getClass()->batchCreateProduct([
            "operateId" => $operateId,
            "info" => $info,
        ]);
    }

    /**
     * 获取商品操作记录
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageLog (int $id) {
        return self::getClass()->getMessageLog([
            "id" => $id,
        ]);
    }

    /**
     * 根据skuIds获取详情
     *
     * @param  array $skuIds skuIds [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku: false 不获取,true:获取 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuIds (array $skuIds, string $from, bool $withOffSku = false) {
        return self::getClass()->getSkuBySkuIds([
            "skuIds" => $skuIds,
            "from" => $from,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNeedInventoryCheckSku (bool $withOffSku = false) {
        return self::getClass()->getNeedInventoryCheckSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取需要进行库存判断的商品sku列表
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  int $categoryId 分类id [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventoryCheckSkuList (int $storeId, int $categoryId = 0, int $page = 1, int $pageSize = 20, bool $withOffSku = false) {
        return self::getClass()->getInventoryCheckSkuList([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
            "page" => $page,
            "pageSize" => $pageSize,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取所有的sku
     *
     * @param  bool $withOffSku 是否获取下架的sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSku (bool $withOffSku = false) {
        return self::getClass()->getAllSku([
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 获取全部产品列表(门店端在使用)
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID 
     * @support  bool $showDeleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  array $storeIds 店铺ids 
     * @support  string $from 查询来源 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 根据商品id获取在售卖的门店ids
     *
     * @param  int $productId 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreIdsByProductId (int $productId) {
        return self::getClass()->getStoreIdsByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * 根据商品id获取对应的skus信息和specifications信息
     *
     * @param  int $id 商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkusAndSpecificationsById (int $id) {
        return self::getClass()->getProductSkusAndSpecificationsById([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}