<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateDateByParams(array $params)
 * @method addPromotionSkuByParams(array $params)
 * @method removePromotionSkuByParams(array $params)
 * @method addPromotionGiveawaySkuByParams(array $params)
 * @method removePromotionGiveawaySkuByParams(array $params)
 * @method finishPromotionByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method onTimeChangeStatusByParams(array $params)
 * @method getProductSkuListByParams(array $params)
 * @method getPromotionProductSkuByParams(array $params)
 * @method getSkuPromotionListByStoreByParams(array $params)
 * @method getAllProductSkuByCategoryByParams(array $params)
 * @method batchAddPromotionSkuByParams(array $params)
 * @method batchAddPromotionGiveawaySkuByParams(array $params)
 */
class Promotion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @support  string $code 活动编号 
     * @support  string $name 产品名称 [ require true ]
     * @support  string $description 活动描述 
     * @support  string $cover 活动主图 
     * @support  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @support  string $assetUrl 活动链接地址 
     * @support  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) [ require true ]
     * @support  int $onlinePromotions 线上活动:1 是 0 否(现在不用) 
     * @support  int $offerOverlay 优惠叠加:1 是 0 否 [ require true ]
     * @support  string $startedAt 开始时间 [ require true ]
     * @support  string $endedAt 结束时间 [ require true ]
     * @support  array $storeIds 活动关联店铺 [ require true ]
     * @support  array $skuIds 商品的sku_id [ require true ]
     * @support  array $rules 活动规则 [ require true ]
     * @support  array $giveawaySkuIds 赠品的sku_id 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  string $code 活动编号 [ require true ]
     * @param  string $description 活动描述 [ require true ]
     * @param  string $cover 活动主图 [ require true ]
     * @param  string $assetUrl 活动链接地址 [ require true ]
     * @param  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) [ require true ]
     * @param  int $onlinePromotions 线上活动:1 是 0 否(现在不用) [ require true ]
     * @param  string $startedAt 开始时间 [ require true ]
     * @param  string $endedAt 结束时间 [ require true ]
     * @param  array $storeIds 活动关联店铺 [ require true ]
     * @param  array $skuIds 商品的sku_id [ require true ]
     * @param  array $giveawaySkuIds 赠品的sku_id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $operateId, int $offlinePromotions, string $name, string $startedAt, string $endedAt, array $skuIds, array $storeIds, int $onlinePromotions = 0, string $code = '', string $description = '', string $cover = '', string $assetUrl = '', array $giveawaySkuIds = []) {
        return self::getClass()->update([
            "id" => $id,
            "operateId" => $operateId,
            "offlinePromotions" => $offlinePromotions,
            "name" => $name,
            "startedAt" => $startedAt,
            "endedAt" => $endedAt,
            "skuIds" => $skuIds,
            "storeIds" => $storeIds,
            "onlinePromotions" => $onlinePromotions,
            "code" => $code,
            "description" => $description,
            "cover" => $cover,
            "assetUrl" => $assetUrl,
            "giveawaySkuIds" => $giveawaySkuIds,
        ]);
    }

    /**
     * 修改促销活动时间
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  string $startedAt 开始时间 [ require true ]
     * @param  string $endedAt 结束时间 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateDate (int $id, int $operateId, string $startedAt, string $endedAt) {
        return self::getClass()->updateDate([
            "id" => $id,
            "operateId" => $operateId,
            "startedAt" => $startedAt,
            "endedAt" => $endedAt,
        ]);
    }

    /**
     * 添加促销的sku
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPromotionSku (int $id, int $operateId, array $skuIds = []) {
        return self::getClass()->addPromotionSku([
            "id" => $id,
            "operateId" => $operateId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 删除促销的sku
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removePromotionSku (int $id, int $operateId, array $skuIds = []) {
        return self::getClass()->removePromotionSku([
            "id" => $id,
            "operateId" => $operateId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 添加促销的买赠商品
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $giveawaySkuIds 赠品的sku_id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPromotionGiveawaySku (int $id, int $operateId, array $giveawaySkuIds = []) {
        return self::getClass()->addPromotionGiveawaySku([
            "id" => $id,
            "operateId" => $operateId,
            "giveawaySkuIds" => $giveawaySkuIds,
        ]);
    }

    /**
     * 删除促销的买赠商品
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $giveawaySkuIds 赠品的sku_id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removePromotionGiveawaySku (int $id, int $operateId, array $giveawaySkuIds = []) {
        return self::getClass()->removePromotionGiveawaySku([
            "id" => $id,
            "operateId" => $operateId,
            "giveawaySkuIds" => $giveawaySkuIds,
        ]);
    }

    /**
     * 结束促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishPromotion (int $id, int $operateId) {
        return self::getClass()->finishPromotion([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @param  string $name 名称(模糊查询) [ require true ]
     * @param  string $status 状态:processing 进行中 ,waiting 未开始 ,over 已结束 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 20, string $name = '', string $status = '', string $type = '') {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "status" => $status,
            "type" => $type,
        ]);
    }

    /**
     * 促销详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 自动修改活动的状态(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimeChangeStatus () {
        return self::getClass()->onTimeChangeStatus();
    }

    /**
     * 获取零售商品列表
     *
     * @param  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @param  int $categoryId 分类id [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuList (string $type, int $page = 1, int $pageSize = 20, int $categoryId = 0, string $name = '') {
        return self::getClass()->getProductSkuList([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
            "categoryId" => $categoryId,
            "name" => $name,
        ]);
    }

    /**
     * 获取促销活动的商品列表
     *
     * @param  int $promotionId 促销活动id [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPromotionProductSku (int $promotionId, int $page = 1, int $pageSize = 20, string $name = '') {
        return self::getClass()->getPromotionProductSku([
            "promotionId" => $promotionId,
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
        ]);
    }

    /**
     * 根据sku获取sku相关的促销信息
     *
     * @param  int $storeId 店铺id [ require true ]
     * @param  array $skuIds skuIds [ require true ]
     * @param  int $offlinePromotions 线下活动 [ require true ]
     * @param  int $onlinePromotions 线上活动 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuPromotionListByStore (int $storeId, array $skuIds, int $offlinePromotions = 1, int $onlinePromotions = 0) {
        return self::getClass()->getSkuPromotionListByStore([
            "storeId" => $storeId,
            "skuIds" => $skuIds,
            "offlinePromotions" => $offlinePromotions,
            "onlinePromotions" => $onlinePromotions,
        ]);
    }

    /**
     * 根据分类获取所有相关的零售商品
     *
     * @param  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @param  int $categoryId 分类id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProductSkuByCategory (int $categoryId, string $type) {
        return self::getClass()->getAllProductSkuByCategory([
            "categoryId" => $categoryId,
            "type" => $type,
        ]);
    }

    /**
     * 批量添加促销活动的sku
     *
     * @param  array $promotionSkuInfo 待批添加的数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAddPromotionSku (array $promotionSkuInfo) {
        return self::getClass()->batchAddPromotionSku([
            "promotionSkuInfo" => $promotionSkuInfo,
        ]);
    }

    /**
     * 添加促销的买赠商品
     *
     * @param  array $promotionGiveawaySkuInfo 待批添加的数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAddPromotionGiveawaySku (array $promotionGiveawaySkuInfo) {
        return self::getClass()->batchAddPromotionGiveawaySku([
            "promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Promotion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Promotion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}