<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method bindingSkuByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 */
class SkuMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建物料编码
     *
     * @param  int $materialCoding 物料编码 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $materialCoding, int $operateId) {
        return self::getClass()->create([
            "materialCoding" => $materialCoding,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 创建物料编码
     *
     * @param  int $id id [ require true ]
     * @param  int $materialCoding 物料编码 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $materialCoding, int $operateId) {
        return self::getClass()->update([
            "id" => $id,
            "materialCoding" => $materialCoding,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关联sku
     *
     * @param  int $id 别名id [Original type uint] [ require true ]
     * @param  array $skuIds 产品skuIds [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindingSku (int $id, int $operateId, array $skuIds = []) {
        return self::getClass()->bindingSku([
            "id" => $id,
            "operateId" => $operateId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 获取物料分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  int $materialCoding 物料编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $materialCoding = 0, int $page = 1, int $pageSize = 20) {
        return self::getClass()->list([
            "materialCoding" => $materialCoding,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料编号详情
     *
     * @param  int $id 物料编号id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除物料编码
     *
     * @param  int $id 物料编码id [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'SkuMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'SkuMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}