<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateDateByParams(array $params)
 * @method addPromotionSkuByParams(array $params)
 * @method removePromotionSkuByParams(array $params)
 * @method promotionSkuUpByParams(array $params)
 * @method promotionSkuOffByParams(array $params)
 * @method finishPromotionByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method setReturnMockByParams(array $params)
 * @method setReturnMockDetailByParams(array $params)
 * @method setReturnMockListByParams(array $params)
 */
class Promotion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @support  string $code 活动编号 
     * @support  string $name 产品名称 [ require true ]
     * @support  string $description 活动描述 
     * @support  string $cover 活动主图 
     * @support  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @support  string $assetUrl 活动链接地址 
     * @support  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) 
     * @support  int $onlinePromotions 线上活动:1 是 0 否(现在不用) 
     * @support  int $offerOverlay 优惠叠加:1 是 0 否 
     * @support  string $startedAt 开始时间 
     * @support  string $endedAt 结束时间 
     * @support  array $storeIds 活动关联店铺 
     * @support  array $skuIds 商品的sku_id 
     * @support  array $productIds 全选的商品ids（商品如果添加，会自动关联上促销活动） 
     * @support  array $rules 活动规则 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 创建促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @support  string $code 活动编号 
     * @support  string $name 产品名称 [ require true ]
     * @support  string $description 活动描述 
     * @support  string $cover 活动主图 
     * @support  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @support  string $assetUrl 活动链接地址 
     * @support  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) 
     * @support  int $onlinePromotions 线上活动:1 是 0 否(现在不用) 
     * @support  int $offerOverlay 优惠叠加:1 是 0 否 
     * @support  string $startedAt 开始时间 
     * @support  string $endedAt 结束时间 
     * @support  array $storeIds 活动关联店铺 
     * @support  array $skuIds 商品的sku_id 
     * @support  array $productIds 全选的商品ids（商品如果添加，会自动关联上促销活动） 
     * @support  array $rules 活动规则 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $operateId) {
        return self::getClass()->update([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 创建促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  string $startedAt 开始时间 [ require true ]
     * @param  string $endedAt 结束时间 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateDate (int $id, string $startedAt, string $endedAt, int $operateId) {
        return self::getClass()->updateDate([
            "id" => $id,
            "startedAt" => $startedAt,
            "endedAt" => $endedAt,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 添加促销的sku
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPromotionSku (int $id, array $skuIds, int $operateId) {
        return self::getClass()->addPromotionSku([
            "id" => $id,
            "skuIds" => $skuIds,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除促销的sku
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removePromotionSku (int $id, array $skuIds, int $operateId) {
        return self::getClass()->removePromotionSku([
            "id" => $id,
            "skuIds" => $skuIds,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 促销的sku上架
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function promotionSkuUp (int $id, array $skuIds, int $operateId) {
        return self::getClass()->promotionSkuUp([
            "id" => $id,
            "skuIds" => $skuIds,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 促销的sku下架
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function promotionSkuOff (int $id, array $skuIds, int $operateId) {
        return self::getClass()->promotionSkuOff([
            "id" => $id,
            "skuIds" => $skuIds,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 结束促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishPromotion (int $id, int $operateId) {
        return self::getClass()->finishPromotion([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @param  string $name 名称(模糊查询) [ require true ]
     * @param  string $status 状态:processing 进行中 ,waiting 未开始 ,over 已结束 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 20, string $name = '', string $status = 'all') {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "status" => $status,
        ]);
    }

    /**
     * 促销详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 结束促销活动
     *
     * @param  int $id 活动id [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * setReturnMock
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setReturnMock () {
        return self::getClass()->setReturnMock();
    }

    /**
     * setReturnMockDetail
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setReturnMockDetail () {
        return self::getClass()->setReturnMockDetail();
    }

    /**
     * setReturnMockList
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setReturnMockList () {
        return self::getClass()->setReturnMockList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Promotion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Promotion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}