<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method batchRemoveByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method treeByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @param  string $name 类目名称 [ require true ]
     * @param  int $parentId 父级类目id [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (string $name, int $parentId = 0, int $operateId = 0) {
        return self::getClass()->create([
            "name" => $name,
            "parentId" => $parentId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 更新类目
     *
     * @param  int $id 类目ID [ require true ]
     * @param  string $name 类目名称 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, int $operateId = 0) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量更新类目
     *
     * @param  array $data 类目数组 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data, int $operateId = 0) {
        return self::getClass()->batchUpdate([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取类目详情
     *
     * @param  int $id 类目ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, bool $showDeleted = false) {
        return self::getClass()->detail([
            "id" => $id,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 类目ID [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId = 0) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量删除
     *
     * @param  array $ids 类目IDS [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchRemove (array $ids, int $operateId = 0) {
        return self::getClass()->batchRemove([
            "ids" => $ids,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 20, int $storeId = 0, bool $showDeleted = false) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "storeId" => $storeId,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  array $ids 类目id数据 [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $storeId = 0, array $ids = [], bool $showDeleted = false) {
        return self::getClass()->all([
            "storeId" => $storeId,
            "ids" => $ids,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 类目树
     *
     * @param  bool $withProducts 是否带产品信息 [ require true ]
     * @param  bool $withDeleted 带上软删除的数据 [ require true ]
     * @param  int $parentId 父级id [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function tree (int $parentId = 0, int $storeId = 0, string $from = 'pc', bool $withProducts = false, bool $withDeleted = false) {
        return self::getClass()->tree([
            "parentId" => $parentId,
            "storeId" => $storeId,
            "from" => $from,
            "withProducts" => $withProducts,
            "withDeleted" => $withDeleted,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}