<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method getDetailByIdsByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method getSkuBySkuCodeByParams(array $params)
 * @method productStoresByParams(array $params)
 * @method judgeProductOfStoreByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 分类ID [ require true ]
     * @support  string $mainImg 产品主图 
     * @support  array $skuBasic 商品sku属性 
     * @support  array $sku 商品sku 
     * @support  array $storeIds 关联店铺ids 
     * @support  int $onlineSales 线上销售:1 是 0 否 [ require true ]
     * @support  int $offlineSales 线下销售 [ require true ]
     * @support  int $aliasId 别名id 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 编辑产品
     *
     * @param  int $id 产品id [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  int $categoryId 分类ID [ require true ]
     * @param  string $mainImg 产品主图 [ require true ]
     * @param  array $skuBasic 商品sku属性 [ require true ]
     * @param  array $sku 商品sku [ require true ]
     * @param  array $storeIds 关联店铺ids [ require true ]
     * @param  int $onlineSales 线上销售:1 是 0 否 [ require true ]
     * @param  int $offlineSales 线下销售 [ require true ]
     * @param  int $aliasId 别名id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $categoryId, int $operateId, int $onlineSales, int $offlineSales, string $name, int $aliasId = 0, string $mainImg = NULL, array $skuBasic = [], array $sku = [], array $storeIds = []) {
        return self::getClass()->update([
            "id" => $id,
            "categoryId" => $categoryId,
            "operateId" => $operateId,
            "onlineSales" => $onlineSales,
            "offlineSales" => $offlineSales,
            "name" => $name,
            "aliasId" => $aliasId,
            "mainImg" => $mainImg,
            "skuBasic" => $skuBasic,
            "sku" => $sku,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  string $status 产品状态 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $from 来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $from, int $storeId = 0, string $status = '') {
        return self::getClass()->detail([
            "id" => $id,
            "from" => $from,
            "storeId" => $storeId,
            "status" => $status,
        ]);
    }

    /**
     * 多个产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @param  string $status 产品状态 [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $from 查询来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByIds (array $ids, string $from, int $storeId = 0, string $status = '') {
        return self::getClass()->getDetailByIds([
            "ids" => $ids,
            "from" => $from,
            "storeId" => $storeId,
            "status" => $status,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID 
     * @support  bool $showDeleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  array $storeIds 店铺ids 
     * @support  array $areaIds 城市ids 
     * @support  string $storeType 门店类型 
     * @support  string $from 查询来源 
     * @support  int $page 当前页 
     * @support  int $pageSize 页内条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取产品列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $categoryId 分类ID 
     * @support  bool $showDeleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  array $storeIds 店铺ids 
     * @support  array $areaIds 城市ids 
     * @support  string $storeType 门店类型 
     * @support  string $from 查询来源 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id, int $operateId) {
        return self::getClass()->up([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function off (int $id, int $operateId) {
        return self::getClass()->off([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据编码获取sku信息
     *
     * @param  string $skuCode 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuBySkuCode (string $skuCode) {
        return self::getClass()->getSkuBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * 产品关联的店铺信息
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productStores (int $id) {
        return self::getClass()->productStores([
            "id" => $id,
        ]);
    }

    /**
     * 校验零售商品是否在店铺中
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @param  int $storeId 店铺id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function judgeProductOfStore (int $id, int $storeId) {
        return self::getClass()->judgeProductOfStore([
            "id" => $id,
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}