<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method recommendConfigInfoByParams(array $params)
 * @method recommendConfigListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\RecommendConfigListCmd $params)
 * @method addRecommendConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\AddConfigCmd $params)
 * @method updateRecommendConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\UpdateConfigCmd $params)
 * @method deleteRecommendConfigByParams(array $params)
 * @method changeRecommendConfigStatusByParams(array $params)
 * @method getConfigSortMaxByParams(array $params)
 * @method configCityListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\ConfigCityListCmd $params)
 * @method getClassificationConfigCityListByParams(array $params)
 * @method getMantuConfigCityListByParams(array $params)
 */
class Recommend {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 推荐配置详情
     *
     * @param  int $recommendConfigId 推荐配置id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\RecommendConfigInfoDTO
     */
    public static function recommendConfigInfo (int $recommendConfigId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->recommendConfigInfo([
                            "recommendConfigId" => $recommendConfigId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\RecommendConfigInfoDTO"
        );
    }

    /**
     * 推荐配置列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\RecommendConfigListCmd $recommendConfigListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\RecommendConfigListDTO
     */
    public static function recommendConfigList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\RecommendConfigListCmd $recommendConfigListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->recommendConfigList($recommendConfigListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\RecommendConfigListDTO"
        );
    }


    /**
     * 添加推荐配置
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\AddConfigCmd $addConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addRecommendConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\AddConfigCmd $addConfigCmd) {
        return self::getClass()->addRecommendConfig($addConfigCmd);
    }


    /**
     * 修改推荐配置
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\UpdateConfigCmd $updateConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRecommendConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\UpdateConfigCmd $updateConfigCmd) {
        return self::getClass()->updateRecommendConfig($updateConfigCmd);
    }


    /**
     * 删除推荐配置
     *
     * @param  int $recommendConfigId 推荐配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteRecommendConfig (int $recommendConfigId) {
        return self::getClass()->deleteRecommendConfig([
            "recommendConfigId" => $recommendConfigId,
        ]);
    }

    /**
     * 更改推荐配置状态
     *
     * @param  int $recommendConfigId 推荐配置id [ require true ]
     * @param  string $status 上架状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeRecommendConfigStatus (int $recommendConfigId, string $status) {
        return self::getClass()->changeRecommendConfigStatus([
            "recommendConfigId" => $recommendConfigId,
            "status" => $status,
        ]);
    }

    /**
     * 获取配置的最大排序
     *
     * @param  string $configType 配置类型 [ require true ]
     * @param  string $brand 品牌 [ require false ]
     * @param  int $classificationId 品牌 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function getConfigSortMax (string $configType, string $brand = '', int $classificationId = 0) {
        return self::getClass()->getConfigSortMax([
            "configType" => $configType,
            "brand" => $brand,
            "classificationId" => $classificationId,
        ]);
    }

    /**
     * 推荐配置列表-用户
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\ConfigCityListCmd $configCityListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\ConfigCityListDTO
     */
    public static function configCityList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Recommend\ConfigCityListCmd $configCityListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->configCityList($configCityListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\ConfigCityListDTO"
        );
    }


    /**
     * 分类推荐配置列表
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  array $cityIds 城市Ids [ require true ]
     * @param  string $configType 配置类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\ClassificationInfoDTO[]
     */
    public static function getClassificationConfigCityList (string $brand, array $cityIds, string $configType) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getClassificationConfigCityList([
                            "brand" => $brand,
                            "cityIds" => $cityIds,
                            "configType" => $configType,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\ClassificationInfoDTO[]"
        );
    }

    /**
     * 缦图摄影推荐配置列表
     *
     * @param  array $cityIds 城市Ids [ require true ]
     * @param  string $configType 配置类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\ClassificationInfoDTO[]
     */
    public static function getMantuConfigCityList (array $cityIds, string $configType) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMantuConfigCityList([
                            "cityIds" => $cityIds,
                            "configType" => $configType,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Recommend\ClassificationInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'Recommend');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'Recommend');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}