<?php
namespace Mainto\Bridge\Invokes\HimoRecommend\ResourceTip\Bridge;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getResourceTipListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipListCmd $params)
 */
class ResourceTip {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取资源提示列表.bridge
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipListCmd $getResourceTipListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipListDTO
     */
    public static function getResourceTipList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipListCmd $getResourceTipListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResourceTipList($getResourceTipListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'ResourceTip\Bridge\ResourceTip');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'ResourceTip\Bridge\ResourceTip');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}