<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getResourceTipListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipListCmd $params)
 * @method getResourceTipByParams(array $params)
 * @method saveResourceTipByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\SaveResourceTipCmd $params)
 * @method deleteResourceTipByParams(array $params)
 * @method getResourceTipConfigByParams(array $params)
 * @method saveResourceTipConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\SaveResourceTipConfigCmd $params)
 * @method deleteResourceTipConfigByParams(array $params)
 * @method getResourceTipConfigsByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipConfigsCmd $params)
 */
class ResourceTip {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取资源提示列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipListCmd $getResourceTipListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipListDTO
     */
    public static function getResourceTipList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipListCmd $getResourceTipListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResourceTipList($getResourceTipListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipListDTO"
        );
    }


    /**
     * 获取资源提示详情
     *
     * @param  int $resourceTipId 资源提示ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipDTO
     */
    public static function getResourceTip (int $resourceTipId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResourceTip([
                            "resourceTipId" => $resourceTipId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipDTO"
        );
    }

    /**
     * 更新资源提示
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\SaveResourceTipCmd $saveResourceTipCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipDTO
     */
    public static function saveResourceTip (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\SaveResourceTipCmd $saveResourceTipCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->saveResourceTip($saveResourceTipCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipDTO"
        );
    }


    /**
     * 删除资源提示
     *
     * @param  int $resourceTipId 资源提示ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteResourceTip (int $resourceTipId) {
        return self::getClass()->deleteResourceTip([
            "resourceTipId" => $resourceTipId,
        ]);
    }

    /**
     * 获取资源提示配置详情
     *
     * @param  int $resourceTipConfigId 资源提示的配置ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipConfigDTO
     */
    public static function getResourceTipConfig (int $resourceTipConfigId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResourceTipConfig([
                            "resourceTipConfigId" => $resourceTipConfigId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipConfigDTO"
        );
    }

    /**
     * 更新资源提示的配置信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\SaveResourceTipConfigCmd $saveResourceTipConfigCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipConfigDTO
     */
    public static function saveResourceTipConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\SaveResourceTipConfigCmd $saveResourceTipConfigCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->saveResourceTipConfig($saveResourceTipConfigCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipConfigDTO"
        );
    }


    /**
     * 删除资源提示的配置信息
     *
     * @param  int $resourceTipConfigId 资源提示的配置ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteResourceTipConfig (int $resourceTipConfigId) {
        return self::getClass()->deleteResourceTipConfig([
            "resourceTipConfigId" => $resourceTipConfigId,
        ]);
    }

    /**
     * 获取多个资源提示配置
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipConfigsCmd $getResourceTipsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipConfigDTO[]
     */
    public static function getResourceTipConfigs (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Resource\GetResourceTipConfigsCmd $getResourceTipsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getResourceTipConfigs($getResourceTipsCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Resource\ResourceTipConfigDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'ResourceTip');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'ResourceTip');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}