<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method popupListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Popup\PopupListCmd $params)
 * @method savePopupByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Popup\SavePopupCmd $params)
 * @method getPopupByParams(array $params)
 * @method deletePopupByParams(array $params)
 */
class Popup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 弹窗列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Popup\PopupListCmd $popupListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Popup\PopupListDTO
     */
    public static function popupList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Popup\PopupListCmd $popupListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->popupList($popupListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Popup\PopupListDTO"
        );
    }


    /**
     * 保存弹窗
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Popup\SavePopupCmd $popupCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function savePopup (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Popup\SavePopupCmd $popupCmd) {
        return self::getClass()->savePopup($popupCmd);
    }


    /**
     * 获取弹窗
     *
     * @param  int $popupId 弹窗ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Popup\PopupDTO
     */
    public static function getPopup (int $popupId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPopup([
                            "popupId" => $popupId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Popup\PopupDTO"
        );
    }

    /**
     * 删除弹窗
     *
     * @param  int $popupId 弹窗ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deletePopup (int $popupId) {
        return self::getClass()->deletePopup([
            "popupId" => $popupId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'Popup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'Popup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}