<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method catalogueInfoByParams(array $params)
 * @method catalogueListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\CatalogueListCmd $params)
 * @method addCatalogueByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueCmd $params)
 * @method updateCatalogueByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueCmd $params)
 * @method addCatalogueConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueConfigCmd $params)
 * @method updateCatalogueConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueConfigCmd $params)
 * @method updateCatalogueConfigsByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\BatchUpdateCatalogueConfigCmd $params)
 * @method deleteCatalogueByParams(array $params)
 * @method deleteCatalogueConfigByParams(array $params)
 * @method deleteCatalogueConfigsByParams(array $params)
 * @method changeCatalogueConfigStatusByParams(array $params)
 * @method catalogueConfigInfoByParams(array $params)
 * @method catalogueSortInfoByParams(array $params)
 */
class Catalogue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 目录详情
     *
     * @param  int $catalogueId 目录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueInfoDTO
     */
    public static function catalogueInfo (int $catalogueId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->catalogueInfo([
                            "catalogueId" => $catalogueId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueInfoDTO"
        );
    }

    /**
     * 目录列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\CatalogueListCmd $catalogueListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueListDTO
     */
    public static function catalogueList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\CatalogueListCmd $catalogueListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->catalogueList($catalogueListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueListDTO"
        );
    }


    /**
     * 添加目录
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueCmd $addCatalogueCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCatalogue (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueCmd $addCatalogueCmd) {
        return self::getClass()->addCatalogue($addCatalogueCmd);
    }


    /**
     * 修改目录
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueCmd $updateCatalogueCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCatalogue (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueCmd $updateCatalogueCmd) {
        return self::getClass()->updateCatalogue($updateCatalogueCmd);
    }


    /**
     * 添加目录配置信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueConfigCmd $addCatalogueConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCatalogueConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueConfigCmd $addCatalogueConfigCmd) {
        return self::getClass()->addCatalogueConfig($addCatalogueConfigCmd);
    }


    /**
     * 更新目录配置信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueConfigCmd $updateCatalogueConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCatalogueConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueConfigCmd $updateCatalogueConfigCmd) {
        return self::getClass()->updateCatalogueConfig($updateCatalogueConfigCmd);
    }


    /**
     * 批量更新目录配置信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\BatchUpdateCatalogueConfigCmd $batchUpdateCatalogueConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCatalogueConfigs (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\BatchUpdateCatalogueConfigCmd $batchUpdateCatalogueConfigCmd) {
        return self::getClass()->updateCatalogueConfigs($batchUpdateCatalogueConfigCmd);
    }


    /**
     * 删除目录
     *
     * @param  int $catalogueId 目录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCatalogue (int $catalogueId) {
        return self::getClass()->deleteCatalogue([
            "catalogueId" => $catalogueId,
        ]);
    }

    /**
     * 删除目录配置信息
     *
     * @param  int $catalogueConfigId 目录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCatalogueConfig (int $catalogueConfigId) {
        return self::getClass()->deleteCatalogueConfig([
            "catalogueConfigId" => $catalogueConfigId,
        ]);
    }

    /**
     * 批量删除目录配置信息
     *
     * @param  array $catalogueConfigIds 目录ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCatalogueConfigs (array $catalogueConfigIds) {
        return self::getClass()->deleteCatalogueConfigs([
            "catalogueConfigIds" => $catalogueConfigIds,
        ]);
    }

    /**
     * 更新目录配置状态
     *
     * @param  array $catalogueConfigIds 目录id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeCatalogueConfigStatus (array $catalogueConfigIds, string $status) {
        return self::getClass()->changeCatalogueConfigStatus([
            "catalogueConfigIds" => $catalogueConfigIds,
            "status" => $status,
        ]);
    }

    /**
     * 目录配置详情
     *
     * @param  int $catalogueConfigId 目录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueConfigDTO
     */
    public static function catalogueConfigInfo (int $catalogueConfigId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->catalogueConfigInfo([
                            "catalogueConfigId" => $catalogueConfigId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueConfigDTO"
        );
    }

    /**
     * 获取目录最大排序 及 配置排序情况
     *
     * @param  int $catalogueId 目录id [ require false ]
     * @param  int $parent 上级目录id [ require false ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueSortInfoDTO
     */
    public static function catalogueSortInfo (string $brand, int $parent = 0, int $catalogueId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->catalogueSortInfo([
                            "brand" => $brand,
                            "parent" => $parent,
                            "catalogueId" => $catalogueId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueSortInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'Catalogue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'Catalogue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}