<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncConfigCityByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\QueueMessage\SyncConfigCityCmd $params)
 */
class QueueMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新城市配置
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\QueueMessage\SyncConfigCityCmd $syncConfigCityCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function syncConfigCity (\Mainto\Bridge\Structs\HimoRecommend\Cmd\QueueMessage\SyncConfigCityCmd $syncConfigCityCmd) {
        return self::getClass()->syncConfigCity($syncConfigCityCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'QueueMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'QueueMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}