<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addClassificationByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\RecommendClassification\AddClassificationCmd $params)
 * @method editClassificationByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\RecommendClassification\EditClassificationCmd $params)
 * @method getClassificationInfoByParams(array $params)
 * @method delClassificationByParams(array $params)
 * @method getClassificationListByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method getMaxSortByParams(array $params)
 */
class RecommendClassification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加配置分类
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\RecommendClassification\AddClassificationCmd $addClassificationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addClassification (\Mainto\Bridge\Structs\HimoRecommend\Cmd\RecommendClassification\AddClassificationCmd $addClassificationCmd) {
        return self::getClass()->addClassification($addClassificationCmd);
    }


    /**
     * 编辑配置分类
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\RecommendClassification\EditClassificationCmd $editClassificationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editClassification (\Mainto\Bridge\Structs\HimoRecommend\Cmd\RecommendClassification\EditClassificationCmd $editClassificationCmd) {
        return self::getClass()->editClassification($editClassificationCmd);
    }


    /**
     * 配置分类详情
     *
     * @param  int $classificationId 分类id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\RecommendClassification\ClassificationInfoDTO
     */
    public static function getClassificationInfo (int $classificationId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getClassificationInfo([
                            "classificationId" => $classificationId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\RecommendClassification\ClassificationInfoDTO"
        );
    }

    /**
     * 删除配置分类
     *
     * @param  int $classificationId 分类id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delClassification (int $classificationId) {
        return self::getClass()->delClassification([
            "classificationId" => $classificationId,
        ]);
    }

    /**
     * 配置分类列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\RecommendClassification\ClassificationListDTO
     */
    public static function getClassificationList (int $page = 1, int $pageSize = 50) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getClassificationList([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\RecommendClassification\ClassificationListDTO"
        );
    }

    /**
     * 配置分类状态变更
     *
     * @param  int $classificationId 分类id [ require true ]
     * @param  string $status 状态 on 上线, off 下线 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStatus (int $classificationId, string $status) {
        return self::getClass()->changeStatus([
            "classificationId" => $classificationId,
            "status" => $status,
        ]);
    }

    /**
     * 配置分类列表
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getMaxSort () {
        return self::getClass()->getMaxSort();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'RecommendClassification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'RecommendClassification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}