<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allConfigDeployTypeByParams(array $params)
 * @method haveStoreCityByParams(array $params)
 * @method allConfigPlatformTypeByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 全部推荐配置类型
     *
     * @throws  \Exception
     * @return  string[]
     */
    public static function allConfigDeployType () {
        return self::getClass()->allConfigDeployType();
    }

    /**
     * 全部推荐配置类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function haveStoreCity () {
        return self::getClass()->haveStoreCity();
    }

    /**
     * 全部推荐配置平台类型
     *
     * @throws  \Exception
     * @return  string[]
     */
    public static function allConfigPlatformType () {
        return self::getClass()->allConfigPlatformType();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}