<?php
namespace Mainto\Bridge\Invokes\HimoRecommend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method catalogueInfoByParams(array $params)
 * @method catalogueListByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\CatalogueListCmd $params)
 * @method addCatalogueByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueCmd $params)
 * @method updateCatalogueByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueCmd $params)
 * @method addCatalogueConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueConfigCmd $params)
 * @method updateCatalogueConfigByParams(array|\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueConfigCmd $params)
 * @method deleteCatalogueByParams(array $params)
 * @method deleteCatalogueConfigByParams(array $params)
 * @method changeCatalogueStatusByParams(array $params)
 */
class Catalogue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 目录详情
     *
     * @param  int $catalogueId 目录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueInfoDTO
     */
    public static function catalogueInfo (int $catalogueId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->catalogueInfo([
                            "catalogueId" => $catalogueId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueInfoDTO"
        );
    }

    /**
     * 目录列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\CatalogueListCmd $catalogueListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueListDTO
     */
    public static function catalogueList (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\CatalogueListCmd $catalogueListCmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->catalogueList($catalogueListCmd),
            "\Mainto\Bridge\Structs\HimoRecommend\DTO\Catalogue\CatalogueListDTO"
        );
    }


    /**
     * 添加目录
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueCmd $addCatalogueCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCatalogue (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueCmd $addCatalogueCmd) {
        return self::getClass()->addCatalogue($addCatalogueCmd);
    }


    /**
     * 修改目录
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueCmd $updateCatalogueCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCatalogue (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueCmd $updateCatalogueCmd) {
        return self::getClass()->updateCatalogue($updateCatalogueCmd);
    }


    /**
     * 添加目录配置信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueConfigCmd $addCatalogueConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addCatalogueConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\AddCatalogueConfigCmd $addCatalogueConfigCmd) {
        return self::getClass()->addCatalogueConfig($addCatalogueConfigCmd);
    }


    /**
     * 更新目录配置信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueConfigCmd $updateCatalogueConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCatalogueConfig (\Mainto\Bridge\Structs\HimoRecommend\Cmd\Catalogue\UpdateCatalogueConfigCmd $updateCatalogueConfigCmd) {
        return self::getClass()->updateCatalogueConfig($updateCatalogueConfigCmd);
    }


    /**
     * 删除目录配置信息
     *
     * @param  int $catalogueId 目录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCatalogue (int $catalogueId) {
        return self::getClass()->deleteCatalogue([
            "catalogueId" => $catalogueId,
        ]);
    }

    /**
     * 删除书签配置信息
     *
     * @param  int $catalogueConfigId 目录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCatalogueConfig (int $catalogueConfigId) {
        return self::getClass()->deleteCatalogueConfig([
            "catalogueConfigId" => $catalogueConfigId,
        ]);
    }

    /**
     * 更新目录状态
     *
     * @param  int $catalogueId 目录id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeCatalogueStatus (int $catalogueId, string $status) {
        return self::getClass()->changeCatalogueStatus([
            "catalogueId" => $catalogueId,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRecommend', 'Catalogue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRecommend', 'Catalogue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}