<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-06 09:42:57
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailOrder
 * @method detailByParams(array $params) 订单详情
 * @method changePayTypeByParams(array $params) 修改订单支付方式
 * @method listByParams(array $params) 订单列表
 * @method closeByParams(array $params) 关闭订单
 * @method changeUserDataByParams(array $params) 修改用户数据
 * @method getIdByNoByParams(array $params) 根据订单号获取订单ID
 * @method getNoByIdByParams(array $params) 根据订单ID获取订单号
 * @method getProductsInOrderByParams(array $params) 根据订单号获取订单下面买的产品
 * @method getProductsInOrdersByParams(array $params) 根据订单号批量获取订单下面买的产品
 * @method closeByPaidByParams(array $params) 关闭订单——已支付的零售订单
 * @method changeOrderStatusByParams(array $params) 修改订单的状态
 * @method logByParams(array $params) 查询订单操作日志
 * @method invoiceByParams(array $params) 根据零售订单id查询发票信息
 */
class RetailOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\RetailOrder";

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 修改订单支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changePayType (int $id, string $pay_type, string $payment_no = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type, "payment_no" => $payment_no]);
    }

    /**
     * 订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 关闭订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id, "reason" => $reason]);
    }

    /**
     * 修改用户数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeUserData (int $id, string $user_name, string $user_phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserData(["id" => $id, "user_name" => $user_name, "user_phone" => $user_phone]);
    }

    /**
     * 根据订单号获取订单ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getIdByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdByNo(["order_no" => $order_no]);
    }

    /**
     * 根据订单ID获取订单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getNoById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNoById(["id" => $id]);
    }

    /**
     * 根据订单号获取订单下面买的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsInOrder (string $order_no = null, int $order_id = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrder(["order_no" => $order_no, "order_id" => $order_id]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsInOrders (array $order_nos = [], array $order_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInOrders(["order_nos" => $order_nos, "order_ids" => $order_ids]);
    }

    /**
     * 关闭订单——已支付的零售订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function closeByPaid (int $id, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByPaid(["id" => $id, "reason" => $reason]);
    }

    /**
     * 修改订单的状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeOrderStatus (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeOrderStatus(["id" => $id]);
    }

    /**
     * 查询订单操作日志
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function log (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->log(["id" => $id]);
    }

    /**
     * 根据零售订单id查询发票信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function invoice (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->invoice(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}