<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-06 09:41:54
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OfflineOrder
 * @method createByParams(array $params) 创建线下订单
 * @method createCallByStoreByParams(array $params) 用于门店端请求 - 创建线下订单
 * @method detailByParams(array $params) 线下订单详情
 * @method detailByNoByParams(array $params) 线下订单详情【更加订单号】
 * @method listByParams(array $params) 线下订单列表
 * @method deleteByParams(array $params) 取消线下订单
 * @method closeByParams(array $params) 关闭线下订单
 * @method itemsByParams(array $params) 线下产品
 * @method payByParams(array $params) 线下订单支付
 * @method changePayTypeByParams(array $params) 财务修改支付方式
 */
class OfflineOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\OfflineOrder";

    /**
     * 创建线下订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto
    */
    public static function create (int $income_item_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create(["income_item_id" => $income_item_id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto"
        );
    }

    /**
     * 用于门店端请求 - 创建线下订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto
    */
    public static function createCallByStore (int $income_item_id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createCallByStore(["income_item_id" => $income_item_id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto"
        );
    }

    /**
     * 线下订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailDto"
        );
    }

    /**
     * 线下订单详情【更加订单号】
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailByNoDto
    */
    public static function detailByNo (string $order_no) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailByNo(["order_no" => $order_no]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderDetailByNoDto"
        );
    }

    /**
     * 线下订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDto
    */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDto"
        );
    }

    /**
     * 取消线下订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 关闭线下订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["id" => $id]);
    }

    /**
     * 线下产品
     * @return  array
    */
    public static function items () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->items(),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\ItemsDto[]"
        );
    }

    /**
     * 线下订单支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDetailDto
    */
    public static function pay (int $id, string $pay_type) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pay(["id" => $id, "pay_type" => $pay_type]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\OfflineOrder\Dto\OfflineOrderListDetailDto"
        );
    }

    /**
     * 财务修改支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changePayType (int $id, string $pay_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}