<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-05-06 09:15:37
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Tools
 * @method putSettingByParams(array $params) 更新配置-只有蜘蛛侠使用其他人禁止调用
 * @method productStaffByParams(array $params) 批量更新产品通关-只有蜘蛛侠、神力使用其他人禁止调用
 * @method operateAbTestByParams(array $params) 添加灰度测试
 * @method abIsEnableStoreIdsByParams(array $params) 多个门店，进行批量开关验证，返回当前启用和非启用数据
 * @method updateProductServiceByParams(array $params) 更新服务-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用
 * @method updateProductPriceByParams(array $params) 更新产品价格-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/update
 * @method changePriceAreaByParams(array $params) 更换价格区-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/changePriceArea
 * @method batchBindPriceAreaByParams(array $params) 批量新绑价格区-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/batchBindPriceArea
 * @method unbindPriceAreaByParams(array $params) 解绑价格区-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/unbindPriceArea
 */
class Tools {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Tools";

    /**
     * 更新配置-只有蜘蛛侠使用其他人禁止调用
     * @return  bool
    */
    public static function putSetting (\Mainto\Bridge\Structs\HimoProduct\Admin\Tool\Cmd\PutSettingCmd $putSettingCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->putSetting($putSettingCmd);
    }

    /**
     * 批量更新产品通关-只有蜘蛛侠、神力使用其他人禁止调用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function productStaff (array $newOldProductIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productStaff(["newOldProductIds" => $newOldProductIds]);
    }

    /**
     * 添加灰度测试
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function operateAbTest (string $featureName, array $storeIds, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operateAbTest(["featureName" => $featureName, "storeIds" => $storeIds, "type" => $type]);
    }

    /**
     * 多个门店，进行批量开关验证，返回当前启用和非启用数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function abIsEnableStoreIds (string $featureName, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abIsEnableStoreIds(["featureName" => $featureName, "storeIds" => $storeIds]);
    }

    /**
     * 更新服务-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateProductService (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductService(["id" => $id]);
    }

    /**
     * 更新产品价格-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/update
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateProductPrice (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductPrice(["id" => $id]);
    }

    /**
     * 更换价格区-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/changePriceArea
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function changePriceArea (int $id, int $new_price_area_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePriceArea(["id" => $id, "new_price_area_id" => $new_price_area_id]);
    }

    /**
     * 批量新绑价格区-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/batchBindPriceArea
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchBindPriceArea (int $id, array $new_price_area_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchBindPriceArea(["id" => $id, "new_price_area_ids" => $new_price_area_ids]);
    }

    /**
     * 解绑价格区-直接桥接产品库服务不做其他处理-神力使用禁止其他伙伴调用：产品服务/_do/Product/Price/unbindPriceArea
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function unbindPriceArea (int $id, int $price_area_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindPriceArea(["id" => $id, "price_area_id" => $price_area_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}