<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-20 14:30:08
 */
namespace Mainto\Bridge\Structs\HimoProduct\Admin\MeiTuan\Cmd\Notice;

class ReceiptNoticeMessageCmd {
    /**
     * @var  string
     * 美团订单号
     * validation: required
     */
    public string $orderId;
    /**
     * @var  string
     * 消息类型(1-下单成功通知（发券通知）2-核销（消费） 3-撤销核销（撤销消费） 4-退款完成（未消费退/已消费退）5-订单创建成功 6-订单支付成功 7-订单取消（用户未支付） 8-订单失败（用户支付成功后因为优惠使用失败或发券失败导致的订单失败
     * validation: required
     */
    public string $messageType;
    /**
     * @var  array
     * 商品信息(size为1)
     * validation: required
     */
    public array $products;
    /**
     * @var  string
     * 消息Id，消息的唯一Id，可用作推送消息处理的幂等键。长度为36的字符串示例：1ec33ae7-5248-4262-aa3f-25ad4c5b2639
     * validation: required
     */
    public string $messageId;
    /**
     * @var  string
     * 订单创建时间（毫秒级时间戳）
     * validation: required
     */
    public string $orderCreateTime;
    /**
     * @var  null|string
     * 扩展字段
     * validation: 
     */
    public ?string $extend = null;
    /**
     * @var  null|string
     * ：交易类型（团购普通单:nib.general.groupbuy，预付：nib.general.prepay）
     * validation: 
     */
    public ?string $bizCode = null;
    /**
     * @var  null|string
     * 预付相关信息
     * validation: 
     */
    public ?string $prepayInfo = null;
    /**
     * @var  null|string
     * 平台用户ID
     * validation: 
     */
    public ?string $opUserId = null;
    /**
     * @var  null|string
     * 用户来源
     * validation: 
     */
    public ?string $userSource = null;
    /**
     * @var  null|string
     * 
     * validation: 
     */
    public ?string $unifiedOrderId = null;

    public function __construct (string $orderId = '', string $messageType = '', array $products = [], string $messageId = '', string $orderCreateTime = '') {
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($messageType)) {
            $this->messageType = $messageType;
        }
        if (!is_null($products)) {
            $this->products = $products;
        }
        if (!is_null($messageId)) {
            $this->messageId = $messageId;
        }
        if (!is_null($orderCreateTime)) {
            $this->orderCreateTime = $orderCreateTime;
        }
    }

    public static function create(string $orderId = '', string $messageType = '', array $products = [], string $messageId = '', string $orderCreateTime = ''): self {
        return new self($orderId, $messageType, $products, $messageId, $orderCreateTime);
    }

    public function setOrderId(string $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setMessageType(string $messageType): self {
        $this->messageType = $messageType;

        return $this;
    }

    public function setProducts(array $products): self {
        $this->products = $products;

        return $this;
    }

    public function setMessageId(string $messageId): self {
        $this->messageId = $messageId;

        return $this;
    }

    public function setOrderCreateTime(string $orderCreateTime): self {
        $this->orderCreateTime = $orderCreateTime;

        return $this;
    }

    public function setExtend(?string $extend): self {
        $this->extend = $extend;

        return $this;
    }

    public function setBizCode(?string $bizCode): self {
        $this->bizCode = $bizCode;

        return $this;
    }

    public function setPrepayInfo(?string $prepayInfo): self {
        $this->prepayInfo = $prepayInfo;

        return $this;
    }

    public function setOpUserId(?string $opUserId): self {
        $this->opUserId = $opUserId;

        return $this;
    }

    public function setUserSource(?string $userSource): self {
        $this->userSource = $userSource;

        return $this;
    }

    public function setUnifiedOrderId(?string $unifiedOrderId): self {
        $this->unifiedOrderId = $unifiedOrderId;

        return $this;
    }
}