<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-22 18:28:03
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderDiff
 * @method createByParams(array $params) 创建一个订单修改(订单完成前)
 * @method setPaidByParams(array $params) 设置diff订单完成支付
 * @method detailByParams(array $params) 获取diff详情
 * @method cancelByParams(array $params) 取消未支付订单
 * @method createUpgradeSkuByParams(array $params) 完成订单之后添加加修加印产品
 * @method orderDiffSuccessHookByParams(array $params) 订单Diff支付成功回调
 * @method orderDiffCancelHookByParams(array $params) 订单Diff支付失败回调
 * @method getNewOrderIdByOrderDiffIdByParams(array $params) 通过orderDiffId获取转门店后的新orderId
 */
class OrderDiff {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\OrderDiff";

    /**
     * 创建一个订单修改(订单完成前)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function create (float $money, float $realMoney, float $needPaidMoney, string $type, string $module = 'himo', bool $isChangeStore = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["money" => $money, "realMoney" => $realMoney, "needPaidMoney" => $needPaidMoney, "type" => $type, "module" => $module, "isChangeStore" => $isChangeStore]);
    }

    /**
     * 设置diff订单完成支付
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setPaid (int $orderId, int $orderDiffId, string $diffType, string $payType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "diffType" => $diffType, "payType" => $payType]);
    }

    /**
     * 获取diff详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $orderDiffId, string $diffType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderDiffId" => $orderDiffId, "diffType" => $diffType]);
    }

    /**
     * 取消未支付订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function cancel (int $orderId, int $orderDiffId, string $reason, string $diffType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancel(["orderId" => $orderId, "orderDiffId" => $orderDiffId, "reason" => $reason, "diffType" => $diffType]);
    }

    /**
     * 完成订单之后添加加修加印产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createUpgradeSku (int $orderId, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUpgradeSku(["orderId" => $orderId, "money" => $money]);
    }

    /**
     * 订单Diff支付成功回调
     * @return  mixed
    */
    public static function orderDiffSuccessHook (\Mainto\Bridge\Structs\HimoProduct\Order\Message\Cmd\OrderModifyOrderSaleCmd $orderModifyOrderSaleCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderDiffSuccessHook($orderModifyOrderSaleCmd);
    }

    /**
     * 订单Diff支付失败回调
     * @return  mixed
    */
    public static function orderDiffCancelHook (\Mainto\Bridge\Structs\HimoProduct\Order\Message\Cmd\OrderModifyCancelCmd $orderModifyCancelCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderDiffCancelHook($orderModifyCancelCmd);
    }

    /**
     * 通过orderDiffId获取转门店后的新orderId
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetNewOrderIdByOrderDiffIdDto
    */
    public static function getNewOrderIdByOrderDiffId (int $orderDiffId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getNewOrderIdByOrderDiffId(["orderDiffId" => $orderDiffId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\Order\Dto\GetNewOrderIdByOrderDiffIdDto"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}