<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-03 11:34:02
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Staff
 * @method listByParams(array $params) 获取员工列表
 * @method storeStaffByParams(array $params) 根据分类获取门店成员列表
 * @method staffPluralismConfirmByParams(array $params) 兼岗确认添加对应门店权限
 * @method staffPluralismStopByParams(array $params) 兼岗结束删除对应门店权限
 * @method staffChangeDepartmentByParams(array $params) 伙伴更新
 * @method getTechnologistListByParams(array $params) 获取技术专家列表
 * @method getStaffByRealOrNickNameByParams(array $params) 通过姓名或花名获取伙伴
 * @method assignSupervisorByParams(array $params) 技术专家关联督导
 * @method getSupervisorByTechnologistByParams(array $params) 通过技术专家获取督导
 * @method getStaffRelationByParams(array $params) 获取专家关联信息
 * @method getStaffByTypeByParams(array $params) 根据分类获取门店成员列表
 * @method queryStaffByParams(array $params) 查询员工id
 * @method getPositionsByParams(array $params) 根据门店获取岗位
 */
class Staff {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Staff";

    /**
     * 获取员工列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["store_id" => $store_id]);
    }

    /**
     * 根据分类获取门店成员列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function storeStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeStaff([]);
    }

    /**
     * 兼岗确认添加对应门店权限
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function staffPluralismConfirm (int $pluralism_store_id, int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismConfirm(["pluralism_store_id" => $pluralism_store_id, "staff_id" => $staff_id]);
    }

    /**
     * 兼岗结束删除对应门店权限
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function staffPluralismStop (int $pluralism_store_id, int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismStop(["pluralism_store_id" => $pluralism_store_id, "staff_id" => $staff_id]);
    }

    /**
     * 伙伴更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function staffChangeDepartment (array $old_staff, array $new_staff) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffChangeDepartment(["old_staff" => $old_staff, "new_staff" => $new_staff]);
    }

    /**
     * 获取技术专家列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getTechnologistList (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTechnologistList(["type" => $type]);
    }

    /**
     * 通过姓名或花名获取伙伴
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffByRealOrNickName (int $technologistId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByRealOrNickName(["technologistId" => $technologistId, "name" => $name]);
    }

    /**
     * 技术专家关联督导
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function assignSupervisor (int $technologist_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignSupervisor(["technologist_id" => $technologist_id]);
    }

    /**
     * 通过技术专家获取督导
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSupervisorByTechnologist () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupervisorByTechnologist([]);
    }

    /**
     * 获取专家关联信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffRelation () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRelation([]);
    }

    /**
     * 根据分类获取门店成员列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffByType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByType([]);
    }

    /**
     * 查询员工id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function queryStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryStaff([]);
    }

    /**
     * 根据门店获取岗位
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPositions () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPositions([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}