<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-20 20:42:59
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Invoice
 * @method createByParams(array $params) 开具发票
 * @method createInvoiceByParams(array $params) 开具发票(RPC调用)
 * @method reopenByParams(array $params) 重新开具发票(RPC调用)
 * @method detailByParams(array $params) 电子发票详情
 * @method detailRefitByParams(array $params) 电子发票详情(直接返回前端需要的数据格式)
 * @method deleteByParams(array $params) 电子发票删除
 * @method completeByParams(array $params) 设置开票完成状态
 * @method listByParams(array $params) 电子发票列表
 * @method cronSubmitFinalCommitByParams(array $params) 定时检查并重开发票
 * @method invalidByParams(array $params) 发票作废(电子票会开红票)
 * @method reviewFailedByParams(array $params) 发票审核不通过
 * @method resendByParams(array $params) 电子发票重新发送
 * @method invoiceListByParams(array $params) 可开发票订单列表
 * @method invoiceSubjectByParams(array $params) 开票主体门店
 * @method canInvoiceListByParams(array $params) 各类订单可开发票订单列表
 */
class Invoice {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\Invoice";

    /**
     * 开具发票
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function create (string $name, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "detail" => $detail]);
    }

    /**
     * 开具发票(RPC调用)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createInvoice (string $name, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createInvoice(["name" => $name, "detail" => $detail]);
    }

    /**
     * 重新开具发票(RPC调用)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function reopen (int $invoice_id, string $name, array $detail) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reopen(["invoice_id" => $invoice_id, "name" => $name, "detail" => $detail]);
    }

    /**
     * 电子发票详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 电子发票详情(直接返回前端需要的数据格式)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detailRefit (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailRefit(["id" => $id]);
    }

    /**
     * 电子发票删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 设置开票完成状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function complete (bool $is_electronic, int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->complete(["is_electronic" => $is_electronic, "id" => $id]);
    }

    /**
     * 电子发票列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list (bool $is_electronic) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["is_electronic" => $is_electronic]);
    }

    /**
     * 定时检查并重开发票
     * @return  bool
    */
    public static function cronSubmitFinalCommit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSubmitFinalCommit();
    }

    /**
     * 发票作废(电子票会开红票)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function invalid (int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->invalid(["invoice_id" => $invoice_id]);
    }

    /**
     * 发票审核不通过
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function reviewFailed (int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewFailed(["invoice_id" => $invoice_id]);
    }

    /**
     * 电子发票重新发送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function resend (int $invoice_id, string $phone = '', string $email = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->resend(["invoice_id" => $invoice_id, "phone" => $phone, "email" => $email]);
    }

    /**
     * 可开发票订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function invoiceList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->invoiceList([]);
    }

    /**
     * 开票主体门店
     * @return  mixed
    */
    public static function invoiceSubject () {
        return RpcClass::getClass(self::$serviceName, self::$className)->invoiceSubject();
    }

    /**
     * 各类订单可开发票订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function canInvoiceList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canInvoiceList([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}