<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-02 14:06:39
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ActivitiesRecord
 * @method searchPagesByParams(array $params) 活动备案-列表(分页)
 * @method searchListByParams(array $params) 活动备案-列表(不分页)
 * @method detailByParams(array $params) 活动备案-详情
 * @method createOrEditByParams(array $params) 活动备案-创建(修改)活动备案并发起审批
 * @method cancelAuditByParams(array $params) 活动备案-撤回审批
 * @method getActivityListByPreferentialTypeAndActivityTypeByParams(array $params) 活动备案-获取指定券码类型的活动
 */
class ActivitiesRecord {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Marketing\\ActivitiesRecord";

    /**
     * 活动备案-列表(分页)
     * @return  \Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordPageDto
    */
    public static function searchPages (?\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchPages($activitiesRecordSearchCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordPageDto"
        );
    }

    /**
     * 活动备案-列表(不分页)
     * @return  array
    */
    public static function searchList (?\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordSearchCmd $activitiesRecordSearchCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchList($activitiesRecordSearchCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDto[]"
        );
    }

    /**
     * 活动备案-详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDetailDto
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail([]),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityRecordDetailDto"
        );
    }

    /**
     * 活动备案-创建(修改)活动备案并发起审批
     * @return  array
    */
    public static function createOrEdit (\Mainto\Bridge\Structs\HimoProduct\Marketing\Cmd\ActivitiesRecordAddCmd $activitiesRecordAddCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrEdit($activitiesRecordAddCmd);
    }

    /**
     * 活动备案-撤回审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelAudit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAudit([]);
    }

    /**
     * 活动备案-获取指定券码类型的活动
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getActivityListByPreferentialTypeAndActivityType (string $preferentialType, string $activityType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityListByPreferentialTypeAndActivityType(["preferentialType" => $preferentialType, "activityType" => $activityType]),
            "\Mainto\Bridge\Structs\HimoProduct\Marketing\Dto\ActivityPassListDto[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}