<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-21 16:07:44
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetailProduct
 * @method detailBySkuByParams(array $params) 根据sku获取产品详情
 * @method getProductListByParams(array $params) 查询零售产品列表
 * @method getStoreGroupListByParams(array $params) 获取城市组列表
 * @method getAllRetailProductByParams(array $params) 获取全部零售产品
 * @method getAllCustomizationProductByParams(array $params) 获取全部定制类型零售产品
 */
class RetailProduct {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\RetailProduct";

    /**
     * 根据sku获取产品详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detailBySku (int $id, bool $withOffSku = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailBySku(["id" => $id, "withOffSku" => $withOffSku]);
    }

    /**
     * 查询零售产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductList (array $sku_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["sku_ids" => $sku_ids]);
    }

    /**
     * 获取城市组列表
     * @return  mixed
    */
    public static function getStoreGroupList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreGroupList();
    }

    /**
     * 获取全部零售产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllRetailProduct (bool $isOnlyShelveUp = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllRetailProduct(["isOnlyShelveUp" => $isOnlyShelveUp]);
    }

    /**
     * 获取全部定制类型零售产品
     * @return  array
    */
    public static function getAllCustomizationProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllCustomizationProduct();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}