<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-02 17:11:45
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SurplusRefund
 * @method createByParams(array $params) 创建退款手续费退款
 * @method listByParams(array $params) 手续费剩余退款列表
 * @method getOrderSurplusRefundListByParams(array $params) 获取订单的可退手续费信息
 * @method detailByParams(array $params) 订单详情
 */
class SurplusRefund {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\SurplusRefund";

    /**
     * 创建退款手续费退款
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\HimoProduct\Admin\SurplusRefund\Cmd\CreateSurplusRefundCmd $createSurplusRefundCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createSurplusRefundCmd);
    }

    /**
     * 手续费剩余退款列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 获取订单的可退手续费信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderSurplusRefundList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderSurplusRefundList(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\SurplusRefund\Dto\OrderSurplusRefundListDto[]"
        );
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderNo" => $orderNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}