<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-19 10:39:21
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GroupOrderRefund
 * @method refundRejectByParams(array $params) 退款拒绝
 * @method refundSuccessByParams(array $params) 退款同意
 * @method listByParams(array $params) 团购订单退款列表
 * @method detailByParams(array $params) 团购订单退款单详情
 */
class GroupOrderRefund {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GroupOrderRefund";

    /**
     * 退款拒绝
     * @return  bool
    */
    public static function refundReject (\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundRejectCmd $groupOrderRefundRejectCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundReject($groupOrderRefundRejectCmd);
    }

    /**
     * 退款同意
     * @return  bool
    */
    public static function refundSuccess (\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundSuccessCmd $groupOrderRefundSuccessCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundSuccess($groupOrderRefundSuccessCmd);
    }

    /**
     * 团购订单退款列表
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundListWithPageDTO
    */
    public static function list (?\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\Cmd\GroupOrderRefundListCmd $groupOrderRefundListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($groupOrderRefundListCmd),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundListWithPageDTO"
        );
    }

    /**
     * 团购订单退款单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundDetailDTO
    */
    public static function detail (int $refundGroupOrderId, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["refundGroupOrderId" => $refundGroupOrderId, "withDeleted" => $withDeleted]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrderRefund\DTO\GroupOrderRefundDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}