<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-19 10:39:21
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GiftCard
 * @method abolishByParams(array $params) 礼品卡作废
 * @method detailByParams(array $params) 获取礼品卡信息
 * @method listByParams(array $params) 获取礼品卡列表(分页)
 * @method allCreateLogByParams(array $params) 获取创建日志列表
 * @method searchByParams(array $params) 搜索礼品卡
 * @method detailInfoByParams(array $params) 礼品卡详情
 * @method paymentListByParams(array $params) 获取礼品卡支付记录分页列表
 * @method balanceByParams(array $params) 获取用户礼品卡余额
 */
class GiftCard {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GiftCard";

    /**
     * 礼品卡作废
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function abolish (array $card_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["card_ids" => $card_ids]);
    }

    /**
     * 获取礼品卡信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 获取礼品卡列表(分页)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 获取创建日志列表
     * @return  mixed
    */
    public static function allCreateLog () {
        return RpcClass::getClass(self::$serviceName, self::$className)->allCreateLog();
    }

    /**
     * 搜索礼品卡
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\Search\Dto\SearchUserGiftCardListDto
    */
    public static function search () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->search([]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\Search\Dto\SearchUserGiftCardListDto"
        );
    }

    /**
     * 礼品卡详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\DetailInfo\Dto\DetailInfoDto
    */
    public static function detailInfo (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailInfo(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\DetailInfo\Dto\DetailInfoDto"
        );
    }

    /**
     * 获取礼品卡支付记录分页列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\PaymentList\Dto\PaymentListDto
    */
    public static function paymentList (int $cardId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paymentList(["cardId" => $cardId]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GiftCard\PaymentList\Dto\PaymentListDto"
        );
    }

    /**
     * 获取用户礼品卡余额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function balance (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->balance(["user_id" => $user_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}