<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-21 14:57:30
 */
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GroupOrder
 * @method listByParams(array $params) 团购订单列表
 * @method listWithParamsByParams(array $params) 团购订单列表
 * @method detailByParams(array $params) 订单详情
 * @method getListByPayByParams(array $params) 根据支付方式获取订单列表
 * @method groupOrderDetailByParams(array $params) 团购订单详情
 * @method changePayTypeByParams(array $params) 财务修改支付方式
 */
class GroupOrder {
    private static string $serviceName = "HimoProduct";

    private static string $className = "Admin\\GroupOrder";

    /**
     * 团购订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 团购订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function listWithParams (array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithParams(["params" => $params]);
    }

    /**
     * 订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id, string $group_order_type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, "group_order_type" => $group_order_type]);
    }

    /**
     * 根据支付方式获取订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getListByPay () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPay([]);
    }

    /**
     * 团购订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrder\DTO\GroupOrderDetailDTO
    */
    public static function groupOrderDetail (string $groupOrderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->groupOrderDetail(["groupOrderNo" => $groupOrderNo]),
            "\Mainto\Bridge\Structs\HimoProduct\Admin\GroupOrder\DTO\GroupOrderDetailDTO"
        );
    }

    /**
     * 财务修改支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changePayType (int $id, int $payId, string $payType, string $paymentNo = '', string $reason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "payId" => $payId, "payType" => $payType, "paymentNo" => $paymentNo, "reason" => $reason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}